using UnityEngine;
using UnityEngine.InputSystem;

public class Controller : MonoBehaviour
{
    public float speed = 1;
    private Rigidbody rb;
    float mx, my;
    public float currentSpeed = 0;
    public GameObject particles;
    private ParticleSystem run;
    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        rb = GetComponent<Rigidbody>();
        run = particles.GetComponent<ParticleSystem>();
    }

    void OnMove(InputValue mv)
    {
        Vector2 movement = mv.Get<Vector2>();
        mx = movement.x;
        my = movement.y;
    }

    private void FixedUpdate()
    {
        rb.AddForce(new Vector3(mx, 0, my) * speed);
        currentSpeed = rb.linearVelocity.magnitude;
        run.enableEmission = currentSpeed > 10f;
    }

    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Pickup"))
        {
            Destroy(other.gameObject);
        }
    }
}
