using UnityEngine;
using UnityEditor;
using System;

public class Displayer : MonoBehaviour
{
    TMPro.TMP_Text texter;
    public GameObject fog;
    public GameObject player;
    private Controller plyrCtl;
    bool switched = false;
    DateTime waiting;
    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        texter = GetComponent<TMPro.TMP_Text>();
        plyrCtl = player.GetComponent<Controller>();
    }

    // Update is called once per frame
    void Update()
    {
        if (switched)
        {
            if (waiting.AddSeconds(5).CompareTo(DateTime.Now) < 0)
            {
#if UNITY_EDITOR
                EditorApplication.isPlaying = false;
#else
                Application.quit();
#endif
            }
            return;
        } else
        {
            texter.text = Master.startingKeys - Master.currentKeys + "/" + Master.startingKeys + '\n' + $"currentSpeed: {plyrCtl.currentSpeed:F2}";
            if (Master.startingKeys - Master.currentKeys == Master.startingKeys)
            {
                texter.text = "the fog is coming";
                switched = true;
                waiting = DateTime.Now;
                fog.SetActive(true);
            }
        }
    }
}
