/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.api.service;

import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.service.QuestTimer;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ExtraQuestsService {
    @NotNull
    public static Set<QuestTimer> getQuestTimers() {
        return ExtraQuests.getInstance().getQuestTimerService().getQuestTimers();
    }

    public static boolean addQuestTimer(@NotNull UUID playerUUID, @NotNull String questID, int seconds) {
        QuestTimer timer = new QuestTimer(playerUUID, questID, seconds);
        if (!ExtraQuests.getInstance().getQuestTimerService().addQuestTimer(timer)) {
            return false;
        }
        ExtraQuestsService.startQuestTimer(timer);
        return true;
    }

    public static boolean removeQuestTimer(@NotNull QuestTimer questTimer) {
        return ExtraQuests.getInstance().getQuestTimerService().removeQuestTimer(questTimer);
    }

    public static boolean questReset(@NotNull QuestTimer questTimer) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        Quest quest = file.getQuest(file.getID((Object)questTimer.questID()));
        if (quest == null) {
            ExtraQuests.getLogger().error("No quest found for {}.", (Object)questTimer.questID());
            ExtraQuestsService.removeQuestTimer(questTimer);
            return false;
        }
        TeamData teamData = FTBTeamsAPI.api().getManager().getTeamForPlayerID(questTimer.playerUUID()).map(arg_0 -> ((ServerQuestFile)file).getOrCreateTeamData(arg_0)).orElse(file.getOrCreateTeamData(questTimer.playerUUID()));
        quest.forceProgress(teamData, new ProgressChange((BaseQuestFile)file, (QuestObjectBase)quest, questTimer.playerUUID()).setReset(true));
        return true;
    }

    public static void startQuestTimer(@NotNull QuestTimer questTimer) {
        TaskTimer.builder().delay((questTimer.endTime() - System.currentTimeMillis()) / 50L).consume(task -> {
            if (!ExtraQuestsService.questReset(questTimer)) {
                task.cancel();
                return;
            }
            ExtraQuestsService.removeQuestTimer(questTimer);
        }).build();
    }
}

