/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests;

import com.mojang.logging.LogUtils;
import com.vecoo.extralib.config.YamlConfigFactory;
import com.vecoo.extraquests.command.ExtraQuestsCommand;
import com.vecoo.extraquests.config.LocaleConfig;
import com.vecoo.extraquests.config.ServerConfig;
import com.vecoo.extraquests.reward.KeyValueReward;
import com.vecoo.extraquests.reward.TimerReward;
import com.vecoo.extraquests.service.QuestTimerService;
import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import lombok.Generated;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ExtraQuests
implements ModInitializer {
    public static final String MOD_ID = "extraquests";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraQuests instance;
    private ServerConfig serverConfig;
    private LocaleConfig localeConfig;
    private QuestTimerService questTimerService;
    private MinecraftServer server;

    public void onInitialize() {
        instance = this;
        this.loadConfig();
        this.registerQuests();
        CommandRegistrationCallback.EVENT.register(ExtraQuestsCommand::register);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.loadStorage());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.questTimerService.save());
    }

    public void loadConfig() {
        this.serverConfig = (ServerConfig)YamlConfigFactory.load(ServerConfig.class, (String)"config/ExtraQuests/config.yml");
        this.localeConfig = (LocaleConfig)YamlConfigFactory.load(LocaleConfig.class, (String)"config/ExtraQuests/locale.yml");
    }

    private void loadStorage() {
        try {
            this.questTimerService = new QuestTimerService("/%directory%/storage/ExtraQuests/", this.server);
            this.questTimerService.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    private void registerQuests() {
        KeyValueTask.TYPE = TaskTypes.register((class_2960)new class_2960(MOD_ID, "key_value"), KeyValueTask::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        KeyValueReward.TYPE = RewardTypes.register((class_2960)new class_2960(MOD_ID, "key_value"), KeyValueReward::new, () -> Icon.getIcon((String)"minecraft:item/paper"));
        TimerReward.TYPE = RewardTypes.register((class_2960)new class_2960(MOD_ID, "timer"), TimerReward::new, () -> Icon.getIcon((String)"minecraft:item/clock_07"));
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getServerConfig() {
        return ExtraQuests.instance.serverConfig;
    }

    public LocaleConfig getLocaleConfig() {
        return ExtraQuests.instance.localeConfig;
    }

    public QuestTimerService getQuestTimerService() {
        return ExtraQuests.instance.questTimerService;
    }

    public MinecraftServer getServer() {
        return ExtraQuests.instance.server;
    }

    @Generated
    public static ExtraQuests getInstance() {
        return instance;
    }
}

