/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.fluid;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.commons.lang3.mutable.MutableInt;

public class SmartFluidTankBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<SmartFluidTankBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<SmartFluidTankBehaviour> INPUT = new BehaviourType("Input");
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT = new BehaviourType("Output");
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    protected TankSegment[] tanks;
    protected InternalFluidHandler capability;
    protected boolean extractionAllowed = true;
    protected boolean insertionAllowed = true;
    protected Runnable fluidUpdateCallback;
    private BehaviourType<SmartFluidTankBehaviour> behaviourType;

    public static SmartFluidTankBehaviour single(SmartBlockEntity be, long capacity) {
        return new SmartFluidTankBehaviour(TYPE, be, 1, capacity, false);
    }

    public SmartFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, long tankCapacity, boolean enforceVariety) {
        super(be);
        this.behaviourType = type;
        this.tanks = new TankSegment[tanks];
        Storage[] handlers = new Storage[tanks];
        for (int i = 0; i < tanks; ++i) {
            TankSegment tankSegment;
            this.tanks[i] = tankSegment = new TankSegment(tankCapacity);
            handlers[i] = tankSegment.tank;
        }
        this.capability = new InternalFluidHandler(handlers, enforceVariety);
        this.fluidUpdateCallback = () -> {};
    }

    public SmartFluidTankBehaviour whenFluidUpdates(Runnable fluidUpdateCallback) {
        this.fluidUpdateCallback = fluidUpdateCallback;
        return this;
    }

    public SmartFluidTankBehaviour allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartFluidTankBehaviour forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().field_9236) {
            return;
        }
        this.forEach(ts -> {
            ts.fluidLevel.forceNextSync();
            ts.onFluidStackChanged();
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        this.forEach(be -> {
            LerpedFloat fluidLevel = be.getFluidLevel();
            if (fluidLevel != null) {
                fluidLevel.tickChaser();
            }
        });
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.updateFluids();
    }

    public void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void updateFluids() {
        this.fluidUpdateCallback.run();
        this.blockEntity.sendData();
        this.blockEntity.method_5431();
    }

    @Override
    public void unload() {
        super.unload();
    }

    public SmartFluidTank getPrimaryHandler() {
        return this.getPrimaryTank().tank;
    }

    public TankSegment getPrimaryTank() {
        return this.tanks[0];
    }

    public TankSegment[] getTanks() {
        return this.tanks;
    }

    public boolean isEmpty() {
        for (TankSegment tankSegment : this.tanks) {
            if (tankSegment.tank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<TankSegment> action) {
        for (TankSegment tankSegment : this.tanks) {
            action.accept(tankSegment);
        }
    }

    public Storage<FluidVariant> getCapability() {
        return this.capability;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        class_2499 tanksNBT = new class_2499();
        this.forEach(ts -> tanksNBT.add((Object)ts.writeNBT()));
        nbt.method_10566(this.getType().getName() + "Tanks", (class_2520)tanksNBT);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        MutableInt index = new MutableInt(0);
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554(this.getType().getName() + "Tanks", 10), c -> {
            if (index.intValue() >= this.tanks.length) {
                return;
            }
            this.tanks[index.intValue()].readNBT((class_2487)c, clientPacket);
            index.increment();
        });
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    public class TankSegment {
        protected SmartFluidTank tank;
        protected LerpedFloat fluidLevel;
        protected FluidStack renderedFluid;

        public TankSegment(long capacity) {
            this.tank = new SmartFluidTank(capacity, f -> this.onFluidStackChanged());
            this.fluidLevel = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
            this.renderedFluid = FluidStack.EMPTY;
        }

        public void onFluidStackChanged() {
            if (!SmartFluidTankBehaviour.this.blockEntity.method_11002()) {
                return;
            }
            this.fluidLevel.chase((double)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()), 0.25, LerpedFloat.Chaser.EXP);
            if (!SmartFluidTankBehaviour.this.getWorld().field_9236) {
                SmartFluidTankBehaviour.this.sendDataLazily();
            }
            if (SmartFluidTankBehaviour.this.blockEntity.isVirtual() && !this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public FluidStack getRenderedFluid() {
            return this.renderedFluid;
        }

        public LerpedFloat getFluidLevel() {
            return this.fluidLevel;
        }

        public float getTotalUnits(float partialTicks) {
            return this.fluidLevel.getValue(partialTicks) * (float)this.tank.getCapacity();
        }

        public class_2487 writeNBT() {
            class_2487 compound = new class_2487();
            compound.method_10566("TankContent", (class_2520)this.tank.writeToNBT(new class_2487()));
            compound.method_10566("Level", (class_2520)this.fluidLevel.writeNBT());
            return compound;
        }

        public void readNBT(class_2487 compound, boolean clientPacket) {
            this.tank.readFromNBT(compound.method_10562("TankContent"));
            this.fluidLevel.readNBT(compound.method_10562("Level"), clientPacket);
            if (!this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public boolean isEmpty(float partialTicks) {
            FluidStack renderedFluid = this.getRenderedFluid();
            if (renderedFluid.isEmpty()) {
                return true;
            }
            float units = this.getTotalUnits(partialTicks);
            return units < 1.0f;
        }

        public SmartFluidTank getTank() {
            return this.tank;
        }
    }

    public class InternalFluidHandler
    extends CombinedTankWrapper {
        public InternalFluidHandler(Storage<FluidVariant>[] handlers, boolean enforceVariety) {
            super(handlers);
            if (enforceVariety) {
                this.enforceVariety();
            }
        }

        @Override
        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!SmartFluidTankBehaviour.this.insertionAllowed) {
                return 0L;
            }
            return super.insert(resource, maxAmount, transaction);
        }

        public long forceFill(FluidStack resource, TransactionContext ctx) {
            return super.insert(resource.getType(), resource.getAmount(), ctx);
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!SmartFluidTankBehaviour.this.extractionAllowed) {
                return 0L;
            }
            return super.extract((Object)resource, maxAmount, transaction);
        }
    }
}

