/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_765;

public class CarriageContraptionEntityRenderer
extends ContraptionEntityRenderer<CarriageContraptionEntity> {
    public CarriageContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, class_4604 clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void render(CarriageContraptionEntity entity, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int overlay) {
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return;
        }
        super.render(entity, yaw, partialTicks, ms, buffers, overlay);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        class_243 position = entity.method_30950(partialTicks);
        float viewYRot = entity.method_5705(partialTicks);
        float viewXRot = entity.method_5695(partialTicks);
        int bogeySpacing = carriage.bogeySpacing;
        carriage.bogeys.forEach(bogey -> {
            class_2338 bogeyPos;
            if (bogey == null) {
                return;
            }
            class_2338 class_23382 = bogeyPos = bogey.isLeading ? class_2338.field_10980 : class_2338.field_10980.method_10079(entity.getInitialOrientation().method_10160(), bogeySpacing);
            if (!VisualizationManager.supportsVisualization((class_1936)entity.method_37908()) && !entity.getContraption().isHiddenInPortal(bogeyPos)) {
                ms.method_22903();
                CarriageContraptionEntityRenderer.translateBogey(ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
                int light = CarriageContraptionEntityRenderer.getBogeyLightCoords(entity, bogey, partialTicks);
                bogey.getStyle().render(bogey.getSize(), partialTicks, ms, buffers, light, overlay, bogey.wheelAngle.getValue(partialTicks), bogey.bogeyData, true);
                ms.method_22909();
            }
            bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, bogey.isLeading);
            if (!carriage.isOnTwoBogeys()) {
                bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, !bogey.isLeading);
            }
        });
    }

    public static void translateBogey(class_4587 ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float partialTicks) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).rotateYDegrees(viewYRot + 90.0f)).rotateXDegrees(-viewXRot)).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, bogey.isLeading ? 0.0f : (float)(-bogeySpacing)).rotateYDegrees(-180.0f)).rotateXDegrees(viewXRot)).rotateYDegrees(-viewYRot - 90.0f)).rotateYDegrees(bogey.yaw.getValue(partialTicks))).rotateXDegrees(bogey.pitch.getValue(partialTicks))).translate(0.0f, 0.5f, 0.0f).rotateZDegrees(selfUpsideDown ? 180.0f : 0.0f)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0f : 0.0f);
    }

    public static int getBogeyLightCoords(CarriageContraptionEntity entity, CarriageBogey bogey, float partialTicks) {
        class_243 anchorPosition = bogey.getAnchorPosition();
        class_2338 lightPos = class_2338.method_49638((class_2374)(anchorPosition == null ? entity.method_31166(partialTicks) : anchorPosition));
        return class_765.method_23687((int)entity.method_37908().method_8314(class_1944.field_9282, lightPos), (int)entity.method_37908().method_8314(class_1944.field_9284, lightPos));
    }
}

