/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlock;
import com.simibubi.create.content.redstone.link.RedstoneLinkFrequencySlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    protected LinkBehaviour link;
    private boolean transmitter;
    public FactoryPanelSupportBehaviour panelSupport;

    public RedstoneLinkBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.panelSupport = new FactoryPanelSupportBehaviour(this, () -> this.link != null && this.link.isListening(), () -> this.receivedSignal > 0, () -> ((RedstoneLinkBlock)AllBlocks.REDSTONE_LINK.get()).updateTransmittedSignal(this.method_11010(), this.field_11863, this.field_11867));
        behaviours.add(this.panelSupport);
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair<ValueBoxTransform, ValueBoxTransform> slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = this.transmitter ? LinkBehaviour.transmitter(this, slots, this::getSignal) : LinkBehaviour.receiver(this, slots, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Transmitter", this.transmitter);
        compound.method_10569("Receive", this.getReceivedSignal());
        compound.method_10556("ReceivedChanged", this.receivedSignalChanged);
        compound.method_10569("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.transmitter = compound.method_10577("Transmitter");
        super.read(compound, clientPacket);
        this.receivedSignal = compound.method_10550("Receive");
        this.receivedSignalChanged = compound.method_10577("ReceivedChanged");
        if (this.field_11863 == null || this.field_11863.field_9236 || !this.link.newPosition) {
            this.transmittedSignal = compound.method_10550("Transmit");
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            LinkBehaviour prevlink = this.link;
            this.removeBehaviour(LinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.REDSTONE_LINK.has(blockState)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.method_11654((class_2769)RedstoneLinkBlock.POWERED)) {
            this.receivedSignalChanged = true;
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)RedstoneLinkBlock.POWERED));
        }
        if (this.receivedSignalChanged) {
            this.updateSelfAndAttached(blockState);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.updateSelfAndAttached(this.method_11010());
    }

    public void updateSelfAndAttached(class_2680 blockState) {
        class_2350 attachedFace = ((class_2350)blockState.method_11654((class_2769)RedstoneLinkBlock.field_10927)).method_10153();
        class_2338 attachedPos = this.field_11867.method_10093(attachedFace);
        this.field_11863.method_8408(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
        this.field_11863.method_8408(attachedPos, this.field_11863.method_8320(attachedPos).method_26204());
        this.receivedSignalChanged = false;
        this.panelSupport.notifyPanels();
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.method_11010().method_11654((class_2769)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

