/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class PackagerItemHandler
extends SnapshotParticipant<Optional<class_1799>>
implements SingleSlotStorage<ItemVariant> {
    private final PackagerBlockEntity blockEntity;
    private Optional<class_1799> newHeldBox = Optional.empty();

    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    private class_1799 getHeldBox() {
        return this.newHeldBox.orElse(this.blockEntity.heldBox);
    }

    private void setHeldBox(class_1799 stack) {
        this.newHeldBox = Optional.of(stack);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1799 box = this.getHeldBox();
        if (!box.method_7960() || !this.blockEntity.queuedExitingPackages.isEmpty()) {
            return 0L;
        }
        if (!PackageItem.isPackage(resource)) {
            return 0L;
        }
        class_1799 stack = resource.toStack(1);
        if (this.blockEntity.unwrapBox(stack, transaction)) {
            TransactionCallback.onSuccess((TransactionContext)transaction, this.blockEntity::scheduleStockCheck);
            return 1L;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        if (this.blockEntity.animationTicks != 0) {
            return 0L;
        }
        class_1799 box = this.getHeldBox();
        if (!resource.matches(box)) {
            return 0L;
        }
        int toExtract = (int)Math.min(maxAmount, (long)box.method_7947());
        int newSize = box.method_7947() - toExtract;
        this.updateSnapshots(transaction);
        this.setHeldBox(box.method_46651(newSize));
        return box.method_7947();
    }

    public boolean isResourceBlank() {
        return this.blockEntity.heldBox.method_7960();
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.blockEntity.heldBox);
    }

    public long getAmount() {
        return this.blockEntity.heldBox.method_7947();
    }

    public long getCapacity() {
        return 1L;
    }

    protected void readSnapshot(Optional<class_1799> snapshot) {
        this.newHeldBox = snapshot;
    }

    protected Optional<class_1799> createSnapshot() {
        return this.newHeldBox;
    }

    protected void onFinalCommit() {
        this.newHeldBox.ifPresent(stack -> {
            this.blockEntity.heldBox = stack;
            this.blockEntity.notifyUpdate();
        });
        this.newHeldBox = Optional.empty();
    }
}

