/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.class_1278;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3954;

public class AllInventoryIdentifiers {
    public static void registerDefaults() {
        InventoryIdentifier.REGISTRY.registerProvider(SimpleRegistry.Provider.forBlockTag(AllTags.AllBlockTags.SINGLE_BLOCK_INVENTORIES.tag, AllInventoryIdentifiers::single));
        InventoryIdentifier.REGISTRY.registerProvider(block -> {
            Collection properties = block.method_9595().method_11659();
            if (properties.contains(class_2281.field_10770) && properties.contains(class_2281.field_10768)) {
                return AllInventoryIdentifiers::chest;
            }
            return null;
        });
        InventoryIdentifier.REGISTRY.registerProvider(block -> {
            if (block instanceof class_3954) {
                return AllInventoryIdentifiers::worldlyContainerBlock;
            }
            return null;
        });
        InventoryIdentifier.REGISTRY.register((class_2248)AllBlocks.ITEM_VAULT.get(), (level, state, face) -> {
            InventoryIdentifier inventoryIdentifier;
            class_2586 be = level.method_8321(face.getPos());
            if (be instanceof ItemVaultBlockEntity) {
                ItemVaultBlockEntity vault = (ItemVaultBlockEntity)be;
                inventoryIdentifier = vault.getInvId();
            } else {
                inventoryIdentifier = null;
            }
            return inventoryIdentifier;
        });
    }

    private static InventoryIdentifier single(class_1937 level, class_2680 state, BlockFace face) {
        return new InventoryIdentifier.Single(face.getPos());
    }

    private static InventoryIdentifier chest(class_1937 level, class_2680 state, BlockFace face) {
        class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        if (type != class_2745.field_12569) {
            class_2350 toOther = class_2281.method_9758((class_2680)state);
            class_2338 otherPos = face.getPos().method_10093(toOther);
            class_2680 otherState = level.method_8320(otherPos);
            if (otherState.method_27852(state.method_26204()) && class_2281.method_9758((class_2680)otherState) == toOther.method_10153()) {
                return new InventoryIdentifier.Pair(face.getPos(), otherPos);
            }
        }
        return new InventoryIdentifier.Single(face.getPos());
    }

    private static InventoryIdentifier worldlyContainerBlock(class_1937 level, class_2680 state, BlockFace face) {
        class_3954 holder = (class_3954)state.method_26204();
        class_1278 container = holder.method_17680(state, (class_1936)level, face.getPos());
        return AllInventoryIdentifiers.ofWorldlyContainer(container, face);
    }

    private static InventoryIdentifier ofWorldlyContainer(class_1278 container, BlockFace face) {
        class_2350 side = face.getFace();
        int[] slots = container.method_5494(side);
        EnumSet<class_2350> directions = EnumSet.of(side);
        for (class_2350 direction : Iterate.directions) {
            int[] faceSlots;
            if (direction == side || !Arrays.equals(slots, faceSlots = container.method_5494(direction))) continue;
            directions.add(direction);
        }
        return new InventoryIdentifier.MultiFace(face.getPos(), directions);
    }

    public static InventoryIdentifier fallback(class_1937 level, class_2680 state, BlockFace face) {
        class_2586 be = level.method_8321(face.getPos());
        if (be instanceof class_1278) {
            class_1278 container = (class_1278)be;
            return AllInventoryIdentifiers.ofWorldlyContainer(container, face);
        }
        return null;
    }
}

