/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers.StandardTraitsLegacyDeserializer;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;

public class AllItemAttributeLegacyDeserializers {
    @ApiStatus.Internal
    public static void register() {
        AllItemAttributeLegacyDeserializers.addLegacyDeserializer(new StandardTraitsLegacyDeserializer());
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("in_tag", (class_2487 tag) -> new InTagAttribute((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tag.method_10558("space"), tag.method_10558("path")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("in_item_group", AllItemAttributeTypes.IN_ITEM_GROUP);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("added_by", (class_2487 tag) -> new AddedByAttribute(tag.method_10558("id")));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_enchant", (class_2487 tag) -> new EnchantAttribute((class_1887)class_7923.field_41176.method_10223(class_2960.method_12829((String)tag.method_10558("id")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("shulker_fill_level", (class_2487 tag) -> new ShulkerFillLevelAttribute(ShulkerFillLevelAttribute.ShulkerLevels.fromKey(tag.method_10558("id"))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_color", (class_2487 tag) -> new ColorAttribute(class_1767.method_7791((int)tag.method_10550("id"))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_fluid", (class_2487 tag) -> new FluidContentsAttribute((class_3611)class_7923.field_41173.method_10223(class_2960.method_12829((String)tag.method_10558("id")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_name", AllItemAttributeTypes.HAS_NAME);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("book_author", AllItemAttributeTypes.BOOK_AUTHOR);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("book_copy", AllItemAttributeTypes.BOOK_COPY);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_amulet", AllItemAttributeTypes.ASTRAL_AMULET);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_constellation", AllItemAttributeTypes.ASTRAL_ATTUNMENT);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_crystal", AllItemAttributeTypes.ASTRAL_CRYSTAL);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_perk_gem", AllItemAttributeTypes.ASTRAL_PERK_GEM);
    }

    private static void createLegacyDeserializer(String nbtKey, ItemAttributeType type) {
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer(nbtKey, (class_2487 tag) -> {
            ItemAttribute attribute = type.createAttribute();
            attribute.load((class_2487)tag);
            return attribute;
        });
    }

    private static void createLegacyDeserializer(final String nbtKey, final Function<class_2487, ItemAttribute> func) {
        AllItemAttributeLegacyDeserializers.addLegacyDeserializer(new ItemAttribute.LegacyDeserializer(){

            @Override
            public String getNBTKey() {
                return nbtKey;
            }

            @Override
            public ItemAttribute readNBT(class_2487 nbt) {
                return (ItemAttribute)func.apply(nbt);
            }
        });
    }

    private static void addLegacyDeserializer(ItemAttribute.LegacyDeserializer legacyDeserializer) {
        ItemAttribute.LegacyDeserializer.ALL.add(legacyDeserializer);
    }
}

