/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class EntityLauncher {
    private int horizontalDistance;
    private int verticalDistance;
    private double yMotion;
    private double xMotion;
    private double totalFlyingTicks;

    public EntityLauncher(int horizontalDistance, int verticalDistance) {
        this.set(horizontalDistance, verticalDistance);
    }

    public void clamp(int max) {
        this.set(Math.min(this.horizontalDistance, max), class_3532.method_17822((double)this.verticalDistance) * Math.min(Math.abs(this.verticalDistance), max));
    }

    public void set(int horizontalDistance, int verticalDistance) {
        this.horizontalDistance = horizontalDistance;
        this.verticalDistance = verticalDistance;
        this.recalculateTrajectory();
    }

    public void applyMotion(class_1297 entity, class_2350 facing) {
        class_243 motionVec = new class_243(0.0, this.yMotion, this.xMotion);
        motionVec = VecHelper.rotate((class_243)motionVec, (double)AngleHelper.horizontalAngle((class_2350)facing), (class_2350.class_2351)class_2350.class_2351.field_11052);
        entity.method_18800(motionVec.field_1352 * 0.91, motionVec.field_1351 * 0.98, motionVec.field_1350 * 0.91);
    }

    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    public int getVerticalDistance() {
        return this.verticalDistance;
    }

    public double getTotalFlyingTicks() {
        return this.totalFlyingTicks;
    }

    public class_243 getGlobalPos(double t, class_2350 d, class_2338 launcher) {
        class_243 start = new class_243((double)((float)launcher.method_10263() + 0.5f), (double)((float)launcher.method_10264() + 0.5f), (double)((float)launcher.method_10260() + 0.5f));
        float xt = this.x(t);
        float yt = this.y(t);
        double progress = class_3532.method_15350((double)(t / this.getTotalFlyingTicks()), (double)0.0, (double)1.0);
        double correctionStrength = Math.pow(progress, 3.0);
        class_243 vec = new class_243(0.0, (double)yt + (double)((float)this.verticalDistance - yt) * correctionStrength * 0.5, (double)xt + (double)((float)this.horizontalDistance - xt) * correctionStrength);
        return VecHelper.rotate((class_243)vec, (double)(180.0f + AngleHelper.horizontalAngle((class_2350)d)), (class_2350.class_2351)class_2350.class_2351.field_11052).method_1019(start);
    }

    public class_243 getGlobalVelocity(double t, class_2350 d, class_2338 launcher) {
        return VecHelper.rotate((class_243)new class_243(0.0, (double)this.dy(t), (double)this.dx(t)), (double)(180.0f + AngleHelper.horizontalAngle((class_2350)d)), (class_2350.class_2351)class_2350.class_2351.field_11052);
    }

    public float x(double t) {
        return (float)(this.xMotion * -10.6033 * (-1.0 + Math.pow(0.91, t)));
    }

    public float y(double t) {
        double f = Math.pow(0.98, t);
        return (float)(this.yMotion * -49.4983 * f + 49.4983 * this.yMotion - 194.033 * f - 3.92 * t + 194.033);
    }

    public float dx(double t) {
        return (float)(this.xMotion * Math.pow(0.91, t));
    }

    public float dy(double t) {
        double f = Math.pow(0.98, t);
        return (float)(this.yMotion * f + (f - 1.0) / -0.020000000000000018 * -0.0784);
    }

    protected void recalculateTrajectory() {
        double xTarget = this.horizontalDistance;
        double yTarget = this.verticalDistance;
        double xError = -7.0E-4 * Math.pow(xTarget + 0.5, 2.0) + 0.484 - Math.min(5.0, yTarget) / 5.0 * Math.min(1.0, 0.076 * xTarget - 0.0014 * xTarget * xTarget);
        double yPeak = Math.max(0.0, yTarget + (xTarget + 0.5) / 8.0) + (double)(xTarget <= 1.0 ? 1 : 4);
        this.yMotion = Math.sqrt(2.0 * yPeak / 13.0) + 0.015 * yPeak;
        double tPeak = Math.log(98.0 / (25.0 * this.yMotion + 98.0)) / (2.0 * Math.log(7.0) - 2.0 * Math.log(5.0) - Math.log(2.0));
        this.totalFlyingTicks = Math.sqrt(yPeak - this.yMotion) * 4.87 + 0.115 * (yPeak - this.yMotion) + tPeak;
        this.xMotion = (xTarget - xError + 0.5) / (-10.6033 * (-1.0 + Math.pow(0.91, this.totalFlyingTicks)));
    }
}

