/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.chute;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import com.simibubi.create.content.logistics.chute.ChuteItemHandler;
import com.simibubi.create.content.logistics.chute.SmartChuteBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class ChuteBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
CustomRenderBoundingBoxBlockEntity,
SidedStorageBlockEntity {
    float pull;
    float push;
    class_1799 item = class_1799.field_8037;
    LerpedFloat itemPosition = LerpedFloat.linear();
    ChuteItemHandler itemHandler = new ChuteItemHandler(this);
    boolean canPickUpItems = false;
    float bottomPullDistance = 0.0f;
    float beltBelowOffset;
    TransportedItemStackHandlerBehaviour beltBelow;
    boolean updateAirFlow = true;
    int airCurrentUpdateCooldown;
    int entitySearchCooldown;
    VersionedInventoryTrackerBehaviour invVersionTracker;
    StorageProvider<ItemVariant> capAbove;
    StorageProvider<ItemVariant> capBelow;

    public ChuteBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.capAbove = StorageProvider.createForItems((class_1937)level, (class_2338)this.field_11867.method_10084());
        this.capBelow = StorageProvider.createForItems((class_1937)level, (class_2338)this.field_11867.method_10074());
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(d -> this.canDirectlyInsertCached()));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        this.registerAwardables(behaviours, AllAdvancements.CHUTE);
    }

    public boolean canDirectlyInsertCached() {
        return this.canPickUpItems;
    }

    private boolean canDirectlyInsert() {
        class_2680 blockState = this.method_11010();
        class_2680 blockStateAbove = this.field_11863.method_8320(this.field_11867.method_10084());
        if (!AbstractChuteBlock.isChute(blockState)) {
            return false;
        }
        if (AbstractChuteBlock.getChuteFacing(blockStateAbove) == class_2350.field_11033) {
            return false;
        }
        if (this.getItemMotion() > 0.0f && this.getInputChutes().isEmpty()) {
            return false;
        }
        return AbstractChuteBlock.isOpenChute(blockState);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.onAdded();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -3.0, 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            this.canPickUpItems = this.canDirectlyInsert();
        }
        boolean clientSide = this.field_11863 != null && this.field_11863.field_9236 && !this.isVirtual();
        float itemMotion = this.getItemMotion();
        if (itemMotion != 0.0f && this.field_11863 != null && this.field_11863.field_9236) {
            this.spawnParticles(itemMotion);
        }
        this.tickAirStreams(itemMotion);
        if (this.item.method_7960() && !clientSide) {
            if (itemMotion < 0.0f) {
                this.handleInputFromAbove();
            }
            if (itemMotion > 0.0f) {
                this.handleInputFromBelow();
            }
            return;
        }
        float nextOffset = this.itemPosition.getValue() + itemMotion;
        if (itemMotion < 0.0f) {
            if (nextOffset < 0.5f) {
                if (!this.handleDownwardOutput(true)) {
                    nextOffset = 0.5f;
                } else if (nextOffset < 0.0f) {
                    this.handleDownwardOutput(clientSide);
                    nextOffset = this.itemPosition.getValue();
                }
            }
        } else if (itemMotion > 0.0f && nextOffset > 0.5f) {
            if (!this.handleUpwardOutput(true)) {
                nextOffset = 0.5f;
            } else if (nextOffset > 1.0f) {
                this.handleUpwardOutput(clientSide);
                nextOffset = this.itemPosition.getValue();
            }
        }
        this.itemPosition.setValue((double)nextOffset);
    }

    private void updateAirFlow(float itemSpeed) {
        this.updateAirFlow = false;
        if (itemSpeed > 0.0f && this.field_11863 != null && !this.field_11863.field_9236) {
            float flowLimit;
            float speed = this.pull - this.push;
            this.beltBelow = null;
            float maxPullDistance = speed >= 128.0f ? 3.0f : (speed >= 64.0f ? 2.0f : (speed >= 32.0f ? 1.0f : class_3532.method_16439((float)(speed / 32.0f), (float)0.0f, (float)1.0f)));
            if (AbstractChuteBlock.isChute(this.field_11863.method_8320(this.field_11867.method_10074()))) {
                maxPullDistance = 0.0f;
            }
            if ((flowLimit = maxPullDistance) > 0.0f) {
                flowLimit = AirCurrent.getFlowLimit(this.field_11863, this.field_11867, maxPullDistance, class_2350.field_11033);
            }
            int i = 1;
            while ((float)i <= flowLimit + 1.0f) {
                TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10087(i), TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    this.beltBelow = behaviour;
                    this.beltBelowOffset = i - 1;
                    break;
                }
                ++i;
            }
            this.bottomPullDistance = Math.max(0.0f, flowLimit);
        }
        this.sendData();
    }

    private void findEntities(float itemSpeed) {
        if (this.bottomPullDistance <= 0.0f && !this.getItem().method_7960() || itemSpeed <= 0.0f || this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_238 searchArea = new class_238(center.method_1031(0.0, (double)(-this.bottomPullDistance) - 0.5, 0.0), center.method_1031(0.0, -0.5, 0.0)).method_1014((double)0.45f);
        for (class_1542 itemEntity : this.field_11863.method_18467(class_1542.class, searchArea)) {
            class_1799 entityItem;
            if (!itemEntity.method_5805() || !this.canAcceptItem(entityItem = itemEntity.method_6983())) continue;
            this.setItem(entityItem.method_7972(), (float)(itemEntity.method_5829().method_1005().field_1351 - (double)this.field_11867.method_10264()));
            itemEntity.method_31472();
            break;
        }
    }

    private void extractFromBelt(float itemSpeed) {
        if (itemSpeed <= 0.0f || this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.getItem().method_7960() && this.beltBelow != null) {
            this.beltBelow.handleCenteredProcessingOnAllItems(0.5f, ts -> {
                if (this.canAcceptItem(ts.stack)) {
                    this.setItem(ts.stack.method_7972(), -this.beltBelowOffset);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    private void tickAirStreams(float itemSpeed) {
        if (!this.field_11863.field_9236 && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow(itemSpeed);
        }
        if (this.entitySearchCooldown-- <= 0 && this.item.method_7960()) {
            this.entitySearchCooldown = 5;
            this.findEntities(itemSpeed);
        }
        this.extractFromBelt(itemSpeed);
    }

    public void blockBelowChanged() {
        this.updateAirFlow = true;
    }

    private void spawnParticles(float itemMotion) {
        float absMotion;
        if (this.field_11863 == null) {
            return;
        }
        class_2680 blockState = this.method_11010();
        boolean up = itemMotion > 0.0f;
        float f = absMotion = up ? itemMotion : -itemMotion;
        if (blockState == null || !AbstractChuteBlock.isChute(blockState)) {
            return;
        }
        if (this.push == 0.0f && this.pull == 0.0f) {
            return;
        }
        if (up && AbstractChuteBlock.isOpenChute(blockState) && BlockHelper.noCollisionInSpace((class_1922)this.field_11863, this.field_11867.method_10084())) {
            this.spawnAirFlow(1.0f, 2.0f, absMotion, 0.5f);
        }
        if (AbstractChuteBlock.getChuteFacing(blockState) != class_2350.field_11033) {
            return;
        }
        if (AbstractChuteBlock.isTransparentChute(blockState)) {
            this.spawnAirFlow(up ? 0.0f : 1.0f, up ? 1.0f : 0.0f, absMotion, 1.0f);
        }
        if (!up && BlockHelper.noCollisionInSpace((class_1922)this.field_11863, this.field_11867.method_10074())) {
            this.spawnAirFlow(0.0f, -1.0f, absMotion, 0.5f);
        }
        if (up && this.canActivate() && this.bottomPullDistance > 0.0f) {
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
        }
    }

    private void spawnAirFlow(float verticalStart, float verticalEnd, float motion, float drag) {
        if (this.field_11863 == null) {
            return;
        }
        AirParticleData airParticleData = new AirParticleData(drag, motion);
        class_243 origin = class_243.method_24954((class_2382)this.field_11867);
        float xOff = Create.RANDOM.nextFloat() * 0.5f + 0.25f;
        float zOff = Create.RANDOM.nextFloat() * 0.5f + 0.25f;
        class_243 v = origin.method_1031((double)xOff, (double)verticalStart, (double)zOff);
        class_243 d = origin.method_1031((double)xOff, (double)verticalEnd, (double)zOff).method_1020(v);
        if (Create.RANDOM.nextFloat() < 2.0f * motion) {
            this.field_11863.method_8494((class_2394)airParticleData, v.field_1352, v.field_1351, v.field_1350, d.field_1352, d.field_1351, d.field_1350);
        }
    }

    private void handleInputFromAbove() {
        Storage<ItemVariant> storage = this.grabCapability(class_2350.field_11036);
        this.handleInput(storage, 1.0f);
    }

    private void handleInputFromBelow() {
        Storage<ItemVariant> storage = this.grabCapability(class_2350.field_11033);
        this.handleInput(storage, 0.0f);
    }

    private void handleInput(@Nullable Storage<ItemVariant> inv, float startLocation) {
        class_1799 extracted;
        if (inv == null) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        if (this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        Predicate<class_1799> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (!(mode != ItemHelper.ExtractionCountMode.UPTO && ItemHelper.extract(inv, canAccept, mode, count, true).method_7960() || (extracted = ItemHelper.extract(inv, canAccept, mode, count, false)).method_7960())) {
            this.setItem(extracted, startLocation);
            return;
        }
        this.invVersionTracker.awaitNewVersion(inv);
    }

    private boolean handleDownwardOutput(boolean simulate) {
        class_2680 blockState = this.method_11010();
        ChuteBlockEntity targetChute = this.getTargetChute(blockState);
        class_2350 direction = AbstractChuteBlock.getChuteFacing(blockState);
        if (this.field_11863 == null || direction == null || !this.canActivate()) {
            return false;
        }
        Storage<ItemVariant> inv = this.grabCapability(class_2350.field_11033);
        if (inv != null) {
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return false;
            }
            if (this.invVersionTracker.stillWaiting(inv)) {
                return false;
            }
            try (Transaction t = TransferUtil.getTransaction();){
                long inserted = inv.insert((Object)ItemVariant.of((class_1799)this.item), (long)this.item.method_7947(), (TransactionContext)t);
                if (inserted != 0L && !simulate) {
                    t.commit();
                }
                class_1799 held = this.getItem();
                if (!simulate) {
                    class_1799 newStack = held.method_7972();
                    newStack.method_7934(ItemHelper.truncateLong(inserted));
                    this.setItem(newStack, this.itemPosition.getValue(0.0f));
                }
                if (inserted != 0L) {
                    boolean bl = true;
                    return bl;
                }
            }
            this.invVersionTracker.awaitNewVersion(inv);
            if (direction == class_2350.field_11033) {
                return false;
            }
        }
        if (targetChute != null) {
            boolean canInsert = targetChute.canAcceptItem(this.item);
            if (!simulate && canInsert) {
                targetChute.setItem(this.item, direction == class_2350.field_11033 ? 1.0f : 0.51f);
                this.setItem(class_1799.field_8037);
            }
            return canInsert;
        }
        if (direction.method_10166().method_10179()) {
            return false;
        }
        if (FunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10074())) == class_2350.field_11033) {
            return false;
        }
        if (class_2248.method_16361((class_1922)this.field_11863, (class_2338)this.field_11867.method_10074())) {
            return false;
        }
        if (!simulate) {
            class_243 dropVec = VecHelper.getCenterOf((class_2382)this.field_11867).method_1031(0.0, -0.75, 0.0);
            class_1542 dropped = new class_1542(this.field_11863, dropVec.field_1352, dropVec.field_1351, dropVec.field_1350, this.item.method_7972());
            dropped.method_6988();
            dropped.method_18800(0.0, -0.25, 0.0);
            this.field_11863.method_8649((class_1297)dropped);
            this.setItem(class_1799.field_8037);
        }
        return true;
    }

    private boolean handleUpwardOutput(boolean simulate) {
        Storage<ItemVariant> inv;
        class_2680 stateAbove = this.field_11863.method_8320(this.field_11867.method_10084());
        if (this.field_11863 == null || !this.canActivate()) {
            return false;
        }
        if (AbstractChuteBlock.isOpenChute(this.method_11010()) && (inv = this.grabCapability(class_2350.field_11036)) != null) {
            if (this.field_11863.field_9236 && !this.isVirtual() && !ChuteBlock.isChute(stateAbove)) {
                return false;
            }
            if (this.invVersionTracker.stillWaiting(inv)) {
                return false;
            }
            try (Transaction t = TransferUtil.getTransaction();){
                long inserted = inv.insert((Object)ItemVariant.of((class_1799)this.item), (long)this.item.method_7947(), (TransactionContext)t);
                if (!simulate) {
                    this.item = this.item.method_7972();
                    this.item.method_7934(ItemHelper.truncateLong(inserted));
                    this.itemHandler.update();
                    this.sendData();
                    t.commit();
                }
                if (inserted != 0L) {
                    boolean bl = true;
                    return bl;
                }
            }
            this.invVersionTracker.awaitNewVersion(inv);
            return false;
        }
        ChuteBlockEntity bestOutput = null;
        List<ChuteBlockEntity> inputChutes = this.getInputChutes();
        for (ChuteBlockEntity targetChute : inputChutes) {
            float itemMotion;
            if (!targetChute.canAcceptItem(this.item) || (itemMotion = targetChute.getItemMotion()) < 0.0f || bestOutput != null && !(bestOutput.getItemMotion() < itemMotion)) continue;
            bestOutput = targetChute;
        }
        if (bestOutput != null) {
            if (!simulate) {
                bestOutput.setItem(this.item, 0.0f);
                this.setItem(class_1799.field_8037);
            }
            return true;
        }
        if (FunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10084())) == class_2350.field_11036) {
            return false;
        }
        if (BlockHelper.hasBlockSolidSide(stateAbove, (class_1922)this.field_11863, this.field_11867.method_10084(), class_2350.field_11033)) {
            return false;
        }
        if (!inputChutes.isEmpty()) {
            return false;
        }
        if (!simulate) {
            class_243 dropVec = VecHelper.getCenterOf((class_2382)this.field_11867).method_1031(0.0, 0.5, 0.0);
            class_1542 dropped = new class_1542(this.field_11863, dropVec.field_1352, dropVec.field_1351, dropVec.field_1350, this.item.method_7972());
            dropped.method_6988();
            dropped.method_18800(0.0, (double)(this.getItemMotion() * 2.0f), 0.0);
            this.field_11863.method_8649((class_1297)dropped);
            this.setItem(class_1799.field_8037);
        }
        return true;
    }

    protected boolean canAcceptItem(class_1799 stack) {
        return this.item.method_7960();
    }

    protected int getExtractionAmount() {
        return 16;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return ItemHelper.ExtractionCountMode.UPTO;
    }

    protected boolean canActivate() {
        return true;
    }

    @Nullable
    private Storage<ItemVariant> grabCapability(class_2350 side) {
        if (this.field_11863 == null) {
            return null;
        }
        StorageProvider<ItemVariant> provider = side == class_2350.field_11036 ? this.capAbove : this.capBelow;
        class_2586 be = provider.findBlockEntity();
        if (be instanceof ChuteBlockEntity && (side != class_2350.field_11033 || !(be instanceof SmartChuteBlockEntity) || this.getItemMotion() > 0.0f)) {
            return null;
        }
        return provider.get(side.method_10153());
    }

    public void setItem(class_1799 stack) {
        this.setItem(stack, this.getItemMotion() < 0.0f ? 1.0f : 0.0f);
    }

    public void setItem(class_1799 stack, float insertionPos) {
        this.item = stack;
        this.itemPosition.startWithValue((double)insertionPos);
        this.itemHandler.update();
        this.invVersionTracker.reset();
        if (!this.field_11863.field_9236) {
            this.notifyUpdate();
            this.award(AllAdvancements.CHUTE);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Item", NBTSerializer.serializeNBT((Object)this.item));
        compound.method_10548("ItemPosition", this.itemPosition.getValue());
        compound.method_10548("Pull", this.pull);
        compound.method_10548("Push", this.push);
        compound.method_10548("BottomAirFlowDistance", this.bottomPullDistance);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        class_1799 previousItem = this.item;
        this.item = class_1799.method_7915((class_2487)compound.method_10562("Item"));
        this.itemHandler.update();
        this.itemPosition.startWithValue((double)compound.method_10583("ItemPosition"));
        this.pull = compound.method_10583("Pull");
        this.push = compound.method_10583("Push");
        this.bottomPullDistance = compound.method_10583("BottomAirFlowDistance");
        super.read(compound, clientPacket);
        if (this.method_11002() && this.field_11863 != null && this.field_11863.field_9236 && !class_1799.method_7973((class_1799)previousItem, (class_1799)this.item) && !this.item.method_7960()) {
            if (this.field_11863.field_9229.method_43048(3) != 0) {
                return;
            }
            class_243 p = VecHelper.getCenterOf((class_2382)this.field_11867);
            p = VecHelper.offsetRandomly((class_243)p, (class_5819)this.field_11863.field_9229, (float)0.5f);
            class_243 m = class_243.field_1353;
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, this.item), p.field_1352, p.field_1351, p.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public float getItemMotion() {
        float fanSpeedModifier = 0.015625f;
        float maxItemSpeed = 20.0f;
        float gravity = 4.0f;
        float motion = (this.push + this.pull) * 0.015625f;
        return (class_3532.method_15363((float)motion, (float)-20.0f, (float)20.0f) + (motion <= 0.0f ? -4.0f : 0.0f)) / 20.0f;
    }

    @Override
    public void destroy() {
        super.destroy();
        ChuteBlockEntity targetChute = this.getTargetChute(this.method_11010());
        List<ChuteBlockEntity> inputChutes = this.getInputChutes();
        if (!this.item.method_7960() && this.field_11863 != null) {
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)this.item);
        }
        this.method_11012();
        if (targetChute != null) {
            targetChute.updatePull();
            targetChute.propagatePush();
        }
        inputChutes.forEach(c -> c.updatePush(inputChutes.size()));
    }

    public void onAdded() {
        this.refreshBlockState();
        this.updatePull();
        ChuteBlockEntity targetChute = this.getTargetChute(this.method_11010());
        if (targetChute != null) {
            targetChute.propagatePush();
        } else {
            this.updatePush(1);
        }
    }

    public void updatePull() {
        float totalPull = this.calculatePull();
        if (this.pull == totalPull) {
            return;
        }
        this.pull = totalPull;
        this.updateAirFlow = true;
        this.sendData();
        ChuteBlockEntity targetChute = this.getTargetChute(this.method_11010());
        if (targetChute != null) {
            targetChute.updatePull();
        }
    }

    public void updatePush(int branchCount) {
        float totalPush = this.calculatePush(branchCount);
        if (this.push == totalPush) {
            return;
        }
        this.updateAirFlow = true;
        this.push = totalPush;
        this.sendData();
        this.propagatePush();
    }

    public void propagatePush() {
        List<ChuteBlockEntity> inputs = this.getInputChutes();
        inputs.forEach(c -> c.updatePush(inputs.size()));
    }

    protected float calculatePull() {
        class_2586 be;
        class_2680 blockStateAbove = this.field_11863.method_8320(this.field_11867.method_10084());
        if (AllBlocks.ENCASED_FAN.has(blockStateAbove) && blockStateAbove.method_11654((class_2769)EncasedFanBlock.FACING) == class_2350.field_11033 && (be = this.field_11863.method_8321(this.field_11867.method_10084())) instanceof EncasedFanBlockEntity) {
            EncasedFanBlockEntity fan = (EncasedFanBlockEntity)be;
            if (!be.method_11015()) {
                return fan.getSpeed();
            }
        }
        float totalPull = 0.0f;
        for (class_2350 d : Iterate.directions) {
            ChuteBlockEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            totalPull += inputChute.pull;
        }
        return totalPull;
    }

    protected float calculatePush(int branchCount) {
        ChuteBlockEntity targetChute;
        class_2586 be;
        if (this.field_11863 == null) {
            return 0.0f;
        }
        class_2680 blockStateBelow = this.field_11863.method_8320(this.field_11867.method_10074());
        if (AllBlocks.ENCASED_FAN.has(blockStateBelow) && blockStateBelow.method_11654((class_2769)EncasedFanBlock.FACING) == class_2350.field_11036 && (be = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof EncasedFanBlockEntity) {
            EncasedFanBlockEntity fan = (EncasedFanBlockEntity)be;
            if (!be.method_11015()) {
                return fan.getSpeed();
            }
        }
        if ((targetChute = this.getTargetChute(this.method_11010())) == null) {
            return 0.0f;
        }
        return targetChute.push / (float)branchCount;
    }

    @Nullable
    private ChuteBlockEntity getTargetChute(class_2680 state) {
        class_2680 chuteState;
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 targetDirection = AbstractChuteBlock.getChuteFacing(state);
        if (targetDirection == null) {
            return null;
        }
        class_2338 chutePos = this.field_11867.method_10074();
        if (targetDirection.method_10166().method_10179()) {
            chutePos = chutePos.method_10093(targetDirection.method_10153());
        }
        if (!AbstractChuteBlock.isChute(chuteState = this.field_11863.method_8320(chutePos))) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(chutePos);
        if (be instanceof ChuteBlockEntity) {
            return (ChuteBlockEntity)be;
        }
        return null;
    }

    private List<ChuteBlockEntity> getInputChutes() {
        LinkedList<ChuteBlockEntity> inputs = new LinkedList<ChuteBlockEntity>();
        for (class_2350 d : Iterate.directions) {
            ChuteBlockEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            inputs.add(inputChute);
        }
        return inputs;
    }

    @Nullable
    private ChuteBlockEntity getInputChute(class_2350 direction) {
        class_2680 chuteState;
        class_2350 chuteFacing;
        if (this.field_11863 == null || direction == class_2350.field_11033) {
            return null;
        }
        direction = direction.method_10153();
        class_2338 chutePos = this.field_11867.method_10084();
        if (direction.method_10166().method_10179()) {
            chutePos = chutePos.method_10093(direction);
        }
        if ((chuteFacing = AbstractChuteBlock.getChuteFacing(chuteState = this.field_11863.method_8320(chutePos))) != direction) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(chutePos);
        if (be instanceof ChuteBlockEntity && !be.method_11015()) {
            return (ChuteBlockEntity)be;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean downward = this.getItemMotion() < 0.0f;
        CreateLang.translate("tooltip.chute.header", new Object[0]).forGoggles(tooltip);
        if (this.pull == 0.0f && this.push == 0.0f) {
            CreateLang.translate("tooltip.chute.no_fans_attached", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        }
        if (this.pull != 0.0f) {
            CreateLang.translate("tooltip.chute.fans_" + (this.pull > 0.0f ? "pull_up" : "push_down"), new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        }
        if (this.push != 0.0f) {
            CreateLang.translate("tooltip.chute.fans_" + (this.push > 0.0f ? "push_up" : "pull_down"), new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        }
        CreateLang.text("-> ").add(CreateLang.translate("tooltip.chute.items_move_" + (downward ? "down" : "up"), new Object[0])).style(class_124.field_1054).forGoggles(tooltip);
        if (!this.item.method_7960()) {
            CreateLang.translate("tooltip.chute.contains", class_2561.method_43471((String)this.item.method_7922()).getString(), this.item.method_7947()).style(class_124.field_1060).forGoggles(tooltip);
        }
        return true;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.itemHandler;
    }

    public class_1799 getItem() {
        return this.item;
    }
}

