/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gauge;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import com.simibubi.create.content.kinetics.gauge.GaugeBlock;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public abstract class GaugeVisual
extends ShaftVisual<GaugeBlockEntity>
implements SimpleDynamicVisual {
    protected final ArrayList<DialFace> faces = new ArrayList(2);
    protected final class_4587 ms = new class_4587();

    protected GaugeVisual(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        GaugeBlock gaugeBlock = (GaugeBlock)this.blockState.method_26204();
        Instancer dialModel = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.GAUGE_DIAL));
        Instancer<TransformedInstance> headModel = this.getHeadModel();
        PoseTransformStack msr = TransformStack.of((class_4587)this.ms);
        msr.translate((class_2382)this.getVisualPosition());
        float progress = class_3532.method_16439((float)AnimationTickHolder.getPartialTicks(), (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        for (class_2350 facing : Iterate.directions) {
            if (!gaugeBlock.shouldRenderHeadOnFace(this.level, this.pos, this.blockState, facing)) continue;
            DialFace face = this.makeFace(facing, (Instancer<TransformedInstance>)dialModel, headModel);
            this.faces.add(face);
            face.setupTransform((TransformStack<?>)msr, progress);
        }
    }

    private DialFace makeFace(class_2350 face, Instancer<TransformedInstance> dialModel, Instancer<TransformedInstance> headModel) {
        return new DialFace(face, (TransformedInstance)dialModel.createInstance(), (TransformedInstance)headModel.createInstance());
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (class_3532.method_15347((float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState)) {
            return;
        }
        float progress = class_3532.method_16439((float)ctx.partialTick(), (float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState);
        PoseTransformStack msr = TransformStack.of((class_4587)this.ms);
        for (DialFace faceEntry : this.faces) {
            faceEntry.updateTransform((TransformStack<?>)msr, progress);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight((FlatLit[])this.faces.stream().flatMap(Couple::stream).toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.faces.forEach(DialFace::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        for (DialFace face : this.faces) {
            face.forEach(consumer);
        }
    }

    protected abstract Instancer<TransformedInstance> getHeadModel();

    protected class DialFace
    extends Couple<TransformedInstance> {
        class_2350 face;

        public DialFace(class_2350 face, TransformedInstance first, TransformedInstance second) {
            super((Object)first, (Object)second);
            this.face = face;
        }

        private void setupTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            this.rotateToFace(msr);
            ((TransformedInstance)this.getSecond()).setTransform(GaugeVisual.this.ms).setChanged();
            ((TransformStack)((TransformStack)msr.translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), class_2350.field_11034)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        private void updateTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            ((TransformStack)((TransformStack)this.rotateToFace(msr).translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), class_2350.field_11034)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        protected TransformStack<?> rotateToFace(TransformStack<?> msr) {
            return (TransformStack)((TransformStack)((TransformStack)msr.center()).rotate((float)((double)((-this.face.method_10144() - 90.0f) / 180.0f) * Math.PI), class_2350.field_11036)).uncenter();
        }

        private void delete() {
            ((TransformedInstance)this.getFirst()).delete();
            ((TransformedInstance)this.getSecond()).delete();
        }
    }

    public static class Stress
    extends GaugeVisual {
        public Stress(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.GAUGE_HEAD_STRESS));
        }
    }

    public static class Speed
    extends GaugeVisual {
        public Speed(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.GAUGE_HEAD_SPEED));
        }
    }
}

