/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.behaviour.interaction;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3499;

public abstract class ConductorBlockInteractionBehavior
extends MovingInteractionBehaviour {
    public abstract boolean isValidConductor(class_2680 var1);

    protected void onScheduleUpdate(boolean hasSchedule, class_2680 currentBlockState, Consumer<class_2680> blockStateSetter) {
    }

    @Override
    public final boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        if (AdventureUtil.isAdventure(player)) {
            return false;
        }
        class_1799 itemInHand = player.method_5998(activeHand);
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return false;
        }
        CarriageContraptionEntity carriageEntity = (CarriageContraptionEntity)contraptionEntity;
        if (activeHand == class_1268.field_5810) {
            return false;
        }
        Contraption contraption = carriageEntity.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        class_3499.class_3501 info = carriageContraption.getBlocks().get(localPos);
        if (info == null || !this.isValidConductor(info.comp_1342())) {
            return false;
        }
        class_2350 assemblyDirection = carriageContraption.getAssemblyDirection();
        for (class_2350 direction : Iterate.directionsInAxis((class_2350.class_2351)assemblyDirection.method_10166())) {
            if (!carriageContraption.inControl(localPos, direction)) continue;
            Train train = carriageEntity.getCarriage().train;
            if (train == null) {
                return false;
            }
            if (player.method_37908().field_9236) {
                return true;
            }
            if (train.runtime.getSchedule() != null) {
                if (train.runtime.paused && !train.runtime.completed) {
                    train.runtime.paused = false;
                    AllSoundEvents.CONFIRM.playOnServer(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 1.0f);
                    player.method_7353((class_2561)CreateLang.translateDirect("schedule.continued", new Object[0]), true);
                    return true;
                }
                if (!itemInHand.method_7960()) {
                    AllSoundEvents.DENY.playOnServer(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 1.0f);
                    player.method_7353((class_2561)CreateLang.translateDirect("schedule.remove_with_empty_hand", new Object[0]), true);
                    return true;
                }
                AllSoundEvents.playItemPickup(player);
                player.method_7353((class_2561)CreateLang.translateDirect(train.runtime.isAutoSchedule ? "schedule.auto_removed_from_train" : "schedule.removed_from_train", new Object[0]), true);
                player.method_6122(activeHand, train.runtime.returnSchedule());
                this.onScheduleUpdate(false, info.comp_1342(), newBlockState -> this.setBlockState(localPos, contraptionEntity, (class_2680)newBlockState));
                return true;
            }
            if (!AllItems.SCHEDULE.isIn(itemInHand)) {
                return true;
            }
            Schedule schedule = ScheduleItem.getSchedule(itemInHand);
            if (schedule == null) {
                return false;
            }
            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 1.0f);
                player.method_7353((class_2561)CreateLang.translateDirect("schedule.no_stops", new Object[0]), true);
                return true;
            }
            this.onScheduleUpdate(true, info.comp_1342(), newBlockState -> this.setBlockState(localPos, contraptionEntity, (class_2680)newBlockState));
            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.awardTo(player);
            AllSoundEvents.CONFIRM.playOnServer(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 1.0f);
            player.method_7353((class_2561)CreateLang.translateDirect("schedule.applied_to_train", new Object[0]).method_27692(class_124.field_1060), true);
            itemInHand.method_7934(1);
            player.method_6122(activeHand, itemInHand.method_7960() ? class_1799.field_8037 : itemInHand);
            return true;
        }
        player.method_7353((class_2561)CreateLang.translateDirect("schedule.non_controlling_seat", new Object[0]), true);
        AllSoundEvents.DENY.playOnServer(player.method_37908(), (class_2382)player.method_24515(), 1.0f, 1.0f);
        return true;
    }

    private void setBlockState(class_2338 localPos, AbstractContraptionEntity contraption, class_2680 newState) {
        class_3499.class_3501 info = contraption.getContraption().getBlocks().get(localPos);
        if (info != null) {
            this.setContraptionBlockData(contraption, localPos, new class_3499.class_3501(info.comp_1341(), newState, info.comp_1343()));
        }
    }

    public static class BlazeBurner
    extends ConductorBlockInteractionBehavior {
        @Override
        public boolean isValidConductor(class_2680 state) {
            return state.method_11654(BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE;
        }
    }
}

