/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.event.hooks.DimensionHooks;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import io.github.fabricators_of_create.porting_lib.level.events.SleepFinishedTimeEvent;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class DimensionListener {
    public static void onPlayerLogin(class_1657 player) {
        DimensionHooks.startInAether(player);
    }

    public static class_1269 onInteractWithPortalFrame(class_1657 player, class_1937 level, class_1268 interactionHand, class_3965 hitResult) {
        class_1799 itemStack;
        class_2350 direction;
        class_2338 blockPos = hitResult.method_17777();
        if (DimensionHooks.createPortal(player, level, blockPos, direction = hitResult.method_17780(), itemStack = player.method_5998(interactionHand), interactionHand)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void onWaterExistsInsidePortalFrame(BlockEvents.NeighborNotifyEvent event) {
        class_3610 fluidState;
        class_2680 blockState;
        class_2338 blockPos;
        class_1936 level = event.getLevel();
        if (DimensionHooks.detectWaterInFrame(level, blockPos = event.getPos(), blockState = level.method_8320(blockPos), fluidState = level.method_8316(blockPos))) {
            event.setCanceled(true);
        }
    }

    public static void onWorldTick(class_3218 level) {
        DimensionHooks.tickTime((class_1937)level);
        DimensionHooks.checkEternalDayConfig((class_1937)level);
    }

    public static void onEntityTravelToDimension(class_3222 player, class_3218 origin, class_3218 destination) {
        class_5321 dimension = destination.method_27983();
        DimensionHooks.dimensionTravel((class_1297)player, (class_5321<class_1937>)dimension);
    }

    public static void onPlayerTraveling(class_1657 player) {
        DimensionHooks.travelling(player);
    }

    public static void onWorldLoad(MinecraftServer server, class_3218 level) {
        DimensionHooks.initializeLevelData(server, level);
    }

    public static void onSleepFinish(SleepFinishedTimeEvent event) {
        class_1936 level = event.getLevel();
        Long time = DimensionHooks.finishSleep(level, event.getNewTime());
        if (time != null) {
            event.setTimeAddition(time.longValue());
        }
    }

    public static class_1269 onTriedToSleep(class_1657 player, class_2338 sleepingPos, boolean vanillaResult) {
        if (DimensionHooks.isEternalDay(player)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void init() {
        UseBlockCallback.EVENT.register(DimensionListener::onInteractWithPortalFrame);
        PlayerEvents.LOGGED_IN.register(DimensionListener::onPlayerLogin);
        BlockEvents.NEIGHBORS_NOTIFY.register(DimensionListener::onWaterExistsInsidePortalFrame);
        ServerTickEvents.END_WORLD_TICK.register(DimensionListener::onWorldTick);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(DimensionListener::onEntityTravelToDimension);
        PlayerTickEvents.START.register(DimensionListener::onPlayerTraveling);
        PlayerTickEvents.END.register(DimensionListener::onPlayerTraveling);
        ServerWorldEvents.LOAD.register(DimensionListener::onWorldLoad);
        SleepFinishedTimeEvent.SLEEP_FINISHED.register(DimensionListener::onSleepFinish);
        EntitySleepEvents.ALLOW_SLEEP_TIME.register(DimensionListener::onTriedToSleep);
    }
}

