/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.level;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.mixin.mixins.client.accessor.LevelRendererAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4543;
import net.minecraft.class_4587;
import net.minecraft.class_5294;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AetherSkyRenderEffects
extends class_5294 {
    private static final class_2960 CLOUDS_LOCATION = new class_2960("textures/environment/clouds.png");
    private static final class_2960 MOON_LOCATION = new class_2960("textures/environment/moon_phases.png");
    private static final class_2960 SUN_LOCATION = new class_2960("textures/environment/sun.png");
    private final class_5294 OVERWORLD = new class_5294.class_5297();
    private final float[] sunriseCol = new float[4];
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private class_243 prevCloudColor = class_243.field_1353;

    public AetherSkyRenderEffects() {
        super(9.5f, true, class_5294.class_5401.field_25640, false, false);
    }

    public void adjustLightmapColors(class_638 level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (((Boolean)AetherConfig.CLIENT.colder_lightmap.get()).booleanValue()) {
            Vector3f vector3f = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f vector3f1 = new Vector3f();
            float f9 = class_765.method_23284((class_2874)level.method_8597(), (int)pixelX) * skyLight;
            float f10 = f9 * (f9 * f9 * 0.6f + 0.4f);
            vector3f1.set(f10, f10, f10);
            boolean flag = level.method_28103().method_28114();
            if (flag) {
                vector3f1.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                AetherSkyRenderEffects.clampColor(vector3f1);
            } else {
                Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).mul(blockLight);
                vector3f1.add((Vector3fc)vector3f2);
                vector3f1.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (class_310.method_1551().field_1773.method_3195(partialTicks) > 0.0f) {
                    float darken = class_310.method_1551().field_1773.method_3195(partialTicks);
                    Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f1).mul(0.7f, 0.6f, 0.6f);
                    vector3f1.lerp((Vector3fc)vector3f3, darken);
                }
            }
            colors.set((Vector3fc)vector3f1);
        }
    }

    private static void clampColor(Vector3f vector) {
        vector.set(class_3532.method_15363((float)vector.x(), (float)0.0f, (float)1.0f), class_3532.method_15363((float)vector.y(), (float)0.0f, (float)1.0f), class_3532.method_15363((float)vector.z(), (float)0.0f, (float)1.0f));
    }

    @Nullable
    public float[] method_28109(float timeOfDay, float partialTicks) {
        if (((Boolean)AetherConfig.CLIENT.green_sunset.get()).booleanValue()) {
            float f1 = class_3532.method_15362((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = 1.0f - (1.0f - class_3532.method_15374((float)(f3 * (float)Math.PI))) * 0.99f;
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.5f + 0.0f;
                this.sunriseCol[1] = f3 * f3 * 0.3f + 0.3f;
                this.sunriseCol[2] = f3 * f3 * 0.5f + 0.3f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }
        float f1 = class_3532.method_15362((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - class_3532.method_15374((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + 0.65f;
            this.sunriseCol[1] = f3 * f3 * 0.7f + 0.25f;
            this.sunriseCol[2] = f3 * f3 * 0.0f + 0.4f;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public class_243 method_28112(class_243 color, float brightness) {
        return this.OVERWORLD.method_28112(color, brightness);
    }

    public boolean method_28110(int x, int z) {
        return this.OVERWORLD.method_28110(x, z);
    }

    public boolean renderClouds(class_638 level, int ticks, float partialTick, class_4587 poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        class_761 levelRenderer = class_310.method_1551().field_1769;
        float cloudHeight = level.method_28103().method_28108();
        if (!Float.isNaN(cloudHeight)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            double d1 = ((float)ticks + partialTick) * 0.03f;
            double d2 = (camX + d1) / 12.0;
            double d3 = cloudHeight - (float)camY + 0.33f;
            double d4 = camZ / 12.0 + (double)0.33f;
            d2 -= (double)(class_3532.method_15357((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(class_3532.method_15357((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)class_3532.method_15357((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)class_3532.method_15357((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)class_3532.method_15357((double)d4));
            class_243 vec3 = this.getCloudColor(level, partialTick);
            int i = class_3532.method_15357((double)d2);
            int j = class_3532.method_15357((double)(d3 / 4.0));
            int k = class_3532.method_15357((double)d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || class_310.method_1551().field_1690.method_1632() != ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() || this.prevCloudColor.method_1025(vec3) > 2.0E-4) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vec3;
                ((LevelRendererAccessor)levelRenderer).aether$setPrevCloudsType(class_310.method_1551().field_1690.method_1632());
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(true);
            }
            if (((LevelRendererAccessor)levelRenderer).aether$isGenerateClouds()) {
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(false);
                class_287 bufferbuilder = class_289.method_1348().method_1349();
                if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null) {
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().close();
                }
                ((LevelRendererAccessor)levelRenderer).aether$setCloudBuffer(new class_291(class_291.class_8555.field_44793));
                class_287.class_7433 renderedBuffer = ((LevelRendererAccessor)levelRenderer).callBuildClouds(bufferbuilder, d2, d3, d4, vec3);
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().method_1353();
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().method_1352(renderedBuffer);
                class_291.method_1354();
            }
            RenderSystem.setShader(class_757::method_34549);
            RenderSystem.setShaderTexture((int)0, (class_2960)CLOUDS_LOCATION);
            class_758.method_3212();
            poseStack.method_22903();
            poseStack.method_22905(12.0f, 1.0f, 12.0f);
            poseStack.method_46416(-f3, f4, -f5);
            if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null && RenderSystem.getShader() != null) {
                int l;
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().method_1353();
                for (int i1 = l = ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() == class_4063.field_18164 ? 0 : 1; i1 < 2; ++i1) {
                    if (i1 == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    class_5944 shaderInstance = RenderSystem.getShader();
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().method_34427(poseStack.method_23760().method_23761(), projectionMatrix, shaderInstance);
                }
                class_291.method_1354();
            }
            poseStack.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
        return true;
    }

    public class_243 getCloudColor(class_638 level, float partialTick) {
        float f = level.method_30274(partialTick);
        float f1 = class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = class_3532.method_15363((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = level.method_8430(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.725f;
            float f7 = 1.0f - f5 * 0.8f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = level.method_8478(partialTick);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.5f;
            float f8 = 1.0f - f9 * 0.7f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new class_243((double)f2, (double)f3, (double)f4);
    }

    public boolean renderSky(class_638 level, int ticks, float partialTick, class_4587 poseStack, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (RenderSystem.getShader() != null) {
            setupFog.run();
            class_761 levelRenderer = class_310.method_1551().field_1769;
            class_243 vec3 = this.getSkyColor(level, camera.method_19326(), partialTick);
            float f = (float)vec3.method_10216();
            float f1 = (float)vec3.method_10214();
            float f2 = (float)vec3.method_10215();
            class_758.method_3212();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            class_5944 shaderInstance = RenderSystem.getShader();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().method_1353();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().method_34427(poseStack.method_23760().method_23761(), projectionMatrix, shaderInstance);
            class_291.method_1354();
            RenderSystem.enableBlend();
            float[] sunRiseRGBA = level.method_28103().method_28109(level.method_30274(partialTick), partialTick);
            if (sunRiseRGBA != null) {
                RenderSystem.setShader(class_757::method_34540);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                float f3 = class_3532.method_15374((float)level.method_8442(partialTick)) < 0.0f ? 180.0f : 0.0f;
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(f3));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                float f4 = sunRiseRGBA[0];
                float f5 = sunRiseRGBA[1];
                float f6 = sunRiseRGBA[2];
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(f4, f5, f6, sunRiseRGBA[3]).method_1344();
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = class_3532.method_15374((float)f7);
                    float f9 = class_3532.method_15362((float)f7);
                    bufferBuilder.method_22918(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunRiseRGBA[3]).method_22915(sunRiseRGBA[0], sunRiseRGBA[1], sunRiseRGBA[2], 0.0f).method_1344();
                }
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
                poseStack.method_22909();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            poseStack.method_22903();
            this.drawCelestialBodies(partialTick, poseStack, level, bufferBuilder);
            float f10 = level.method_23787(partialTick);
            if (f10 > 0.0f && class_757.method_34539() != null) {
                RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                class_758.method_23792();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().method_1353();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
                class_291.method_1354();
                setupFog.run();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            poseStack.method_22909();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public class_243 getSkyColor(@NotNull class_638 level, class_243 pos, float partialTick) {
        float f9;
        float f = level.method_30274(partialTick);
        class_243 vec3 = pos.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_4543 biomeManager = level.method_22385();
        class_243 vec31 = class_6491.method_24895((class_243)vec3, (x, y, z) -> class_243.method_24457((int)((class_1959)biomeManager.method_24854(x, y, z).comp_349()).method_8697()));
        float f1 = class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = class_3532.method_15363((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.method_10216() * f1;
        float f3 = (float)vec31.method_10214() * f1;
        float f4 = (float)vec31.method_10215() * f1;
        float f5 = level.method_8430(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.61f;
            float f7 = 1.0f - f5 * 0.2f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = level.method_8478(partialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.48f;
            float f8 = 1.0f - f9 * 0.21f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (!((Boolean)class_310.method_1551().field_1690.method_41784().method_41753()).booleanValue() && level.method_23789() > 0) {
            float f11 = (float)level.method_23789() - partialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + f11;
        }
        return new class_243((double)f2, (double)f3, (double)f4);
    }

    private void drawCelestialBodies(float partialTick, class_4587 poseStack, class_638 level, class_287 bufferBuilder) {
        float moonOpacity;
        float sunOpacity;
        long dayTime = level.method_8532() % 72000L;
        if (dayTime > 71400L) {
            sunOpacity = Math.min((float)(dayTime -= 71400L) * 0.00167f, 1.0f);
            moonOpacity = Math.max(1.0f - (float)dayTime * 0.00167f, 0.0f);
        } else if (dayTime > 38400L) {
            sunOpacity = Math.max(1.0f - (float)(dayTime -= 38400L) * 0.00167f, 0.0f);
            moonOpacity = Math.min((float)dayTime * 0.00167f, 1.0f);
        } else {
            sunOpacity = 1.0f;
            moonOpacity = 0.0f;
        }
        sunOpacity -= level.method_8430(partialTick);
        moonOpacity -= level.method_8430(partialTick);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(level.method_30274(partialTick) * 360.0f));
        Matrix4f matrix4f1 = poseStack.method_23760().method_23761();
        float celestialOffset = 30.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)sunOpacity);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)SUN_LOCATION);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f1, -celestialOffset, 100.0f, -celestialOffset).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f1, celestialOffset, 100.0f, -celestialOffset).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f1, celestialOffset, 100.0f, celestialOffset).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix4f1, -celestialOffset, 100.0f, celestialOffset).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)moonOpacity);
        celestialOffset = 20.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)MOON_LOCATION);
        int moonPhase = level.method_30273();
        int textureX = moonPhase % 4;
        int textureY = moonPhase / 4 % 2;
        float uLeft = (float)textureX / 4.0f;
        float vDown = (float)textureY / 2.0f;
        float uRight = (float)(textureX + 1) / 4.0f;
        float vUp = (float)(textureY + 1) / 2.0f;
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f1, -celestialOffset, -100.0f, celestialOffset).method_22913(uRight, vUp).method_1344();
        bufferBuilder.method_22918(matrix4f1, celestialOffset, -100.0f, celestialOffset).method_22913(uLeft, vUp).method_1344();
        bufferBuilder.method_22918(matrix4f1, celestialOffset, -100.0f, -celestialOffset).method_22913(uLeft, vDown).method_1344();
        bufferBuilder.method_22918(matrix4f1, -celestialOffset, -100.0f, -celestialOffset).method_22913(uRight, vDown).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }
}

