/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.inventory.LorePageButton;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class LoreBookScreen
extends class_465<LoreBookMenu> {
    private static final class_2960 TEXTURE_LORE_BACKING = new class_2960("aether", "textures/gui/menu/lore_backing.png");
    private static final class_2960 TEXTURE_LORE_BOOK = new class_2960("aether", "textures/gui/menu/lore_book.png");
    private final Map<Integer, List<class_5481>> pages = new HashMap<Integer, List<class_5481>>();
    private LorePageButton previousButton;
    private LorePageButton nextButton;
    private int currentPageNumber;
    private class_1799 lastStack;

    public LoreBookScreen(LoreBookMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = 256;
        this.field_2779 = 199;
    }

    protected void method_25426() {
        super.method_25426();
        int xPos = (this.field_22789 - this.field_2792) / 2;
        int yPos = (this.field_22790 - this.field_2779) / 2;
        this.previousButton = (LorePageButton)this.method_37063((class_364)new LorePageButton(new class_4185.class_7840((class_2561)class_2561.method_43470((String)"<"), button -> {
            if (this.currentPageNumber > 0) {
                --this.currentPageNumber;
            }
        }).method_46434(xPos + 14, yPos + 169, 20, 20)));
        this.nextButton = (LorePageButton)this.method_37063((class_364)new LorePageButton(new class_4185.class_7840((class_2561)class_2561.method_43470((String)">"), button -> {
            if (this.currentPageNumber < this.pages.size() - 1) {
                ++this.currentPageNumber;
            }
        }).method_46434(xPos + 221, yPos + 169, 20, 20)));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        this.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int x, int y) {
        String entryKey;
        class_5250 previous = class_2561.method_43471((String)"gui.aether.book_of_lore.previous");
        class_5250 next = class_2561.method_43471((String)"gui.aether.book_of_lore.next");
        this.drawNormalBookText(guiGraphics, this.field_22793, (class_2561)previous, 13, 158);
        this.drawNormalBookText(guiGraphics, this.field_22793, (class_2561)next, 221, 158);
        class_5250 book = class_2561.method_43471((String)"gui.aether.book_of_lore.book");
        class_5250 ofLore = class_2561.method_43471((String)"gui.aether.book_of_lore.of_lore");
        this.drawCenteredBookText(guiGraphics, this.field_22793, (class_2561)book, 75, 20);
        this.drawCenteredBookText(guiGraphics, this.field_22793, (class_2561)ofLore, 75, 30);
        class_5250 item = class_2561.method_43471((String)"gui.aether.book_of_lore.item");
        this.drawRightBookText(guiGraphics, this.field_22793, (class_2561)item, 78, 67);
        class_1799 itemStack = ((class_1735)((LoreBookMenu)this.method_17577()).field_7761.get(0)).method_7677();
        if (!itemStack.method_7960() && class_1074.method_4663((String)(entryKey = ((LoreBookMenu)this.method_17577()).getLoreEntryKey(itemStack)))) {
            class_5250 entry = class_2561.method_43471((String)entryKey);
            this.createPages((class_2561)entry);
            if (this.currentPageNumber == 0) {
                class_5250 title = itemStack.method_7964().method_27662();
                this.createText(guiGraphics, this.field_22793.method_1728((class_5348)title, 98), 136, 10);
                this.createText(guiGraphics, this.pages.get(0), 136, 32);
            } else {
                this.createText(guiGraphics, this.pages.get(this.currentPageNumber), 136, 10);
            }
        }
        if (itemStack.method_7960() || !itemStack.method_31574(this.lastStack.method_7909())) {
            this.pages.clear();
            this.currentPageNumber = 0;
        }
        this.previousButton.field_22763 = this.currentPageNumber > 0;
        this.nextButton.field_22763 = this.currentPageNumber < this.pages.size() - 1;
        this.lastStack = itemStack;
    }

    private void createPages(class_2561 loreEntry) {
        ArrayList formattedText = new ArrayList(this.field_22793.method_1728((class_5348)loreEntry, 98));
        if (formattedText.size() < 6) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.pages.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 6);
            this.pages.put(0, firstPage);
            List remainingPages = formattedText.subList(6, formattedText.size());
            List list = Lists.partition(remainingPages, (int)8);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.pages.put(i, (List)list.get(i - 1));
            }
        }
    }

    private void createText(class_332 guiGraphics, List<class_5481> reorderingProcessors, int x, int y) {
        int length = 0;
        for (class_5481 line : reorderingProcessors) {
            this.drawBookText(guiGraphics, this.field_22793, line, x, y + length * 10);
            ++length;
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int x, int y) {
        int xPos = (this.field_22789 - this.field_2792) / 2;
        int yPos = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25290(TEXTURE_LORE_BACKING, xPos, yPos - 4, 0.0f, 0.0f, this.field_2792, this.field_2779 + 56, 256, 256);
        guiGraphics.method_25290(TEXTURE_LORE_BOOK, xPos + 12, yPos + 2, 0.0f, 0.0f, this.field_2792, this.field_2779 + 56, 256, 256);
    }

    private void drawNormalBookText(class_332 guiGraphics, class_327 fontRenderer, class_2561 component, int x, int y) {
        class_5481 sequence = component.method_30937();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x, y);
    }

    private void drawRightBookText(class_332 guiGraphics, class_327 fontRenderer, class_2561 component, int x, int y) {
        class_5481 sequence = component.method_30937();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.method_30880(sequence), y);
    }

    private void drawCenteredBookText(class_332 guiGraphics, class_327 fontRenderer, class_2561 component, int x, int y) {
        class_5481 sequence = component.method_30937();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.method_30880(sequence) / 2, y);
    }

    private void drawBookText(class_332 guiGraphics, class_327 fontRenderer, class_5481 sequence, int x, int y) {
        guiGraphics.method_51430(fontRenderer, sequence, x, y, 0x404040, false);
    }
}

