/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.indrev;

import com.google.common.collect.Lists;
import com.kneelawk.extramodintegrations.ExMIMod;
import com.kneelawk.extramodintegrations.indrev.IRIntegration;
import com.kneelawk.extramodintegrations.indrev.ModuleEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.steven.indrev.WCustomTabPanel;
import me.steven.indrev.blockentities.modularworkbench.ModularWorkbenchBlockEntity;
import me.steven.indrev.components.InventoryComponent;
import me.steven.indrev.gui.screenhandlers.machines.ModularWorkbenchScreenHandler;
import me.steven.indrev.inventories.IRInventory;
import me.steven.indrev.packets.common.SelectModuleOnWorkbenchPacket;
import me.steven.indrev.recipes.machines.ModuleRecipe;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ModuleRecipeHandler
implements StandardRecipeHandler<ModularWorkbenchScreenHandler> {
    private static final int CRAFTING_START = 3;
    private static final int CRAFTING_STOP = 15;
    private static final int MAX_INPUT_SLOTS = 6;
    private static final Field TAB_PANEL_WIDGETS;

    public List<class_1735> getInputSources(ModularWorkbenchScreenHandler handler) {
        ModularInventory inv = ModuleRecipeHandler.getInventory(handler);
        if (inv == null) {
            return List.of();
        }
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < 36; ++i) {
            inputs.add(handler.method_7611(i));
        }
        ModuleRecipeHandler.addCraftingInputs(handler, inv.inventory, inputs);
        return inputs;
    }

    public List<class_1735> getCraftingSlots(ModularWorkbenchScreenHandler handler) {
        ModularInventory inv = ModuleRecipeHandler.getInventory(handler);
        if (inv == null) {
            return List.of();
        }
        ArrayList inputs = Lists.newArrayList();
        ModuleRecipeHandler.addCraftingInputs(handler, inv.inventory, inputs);
        return inputs;
    }

    public List<class_1735> getCraftingSlots(EmiRecipe recipe, ModularWorkbenchScreenHandler handler) {
        if (!(recipe instanceof ModuleEmiRecipe)) {
            return List.of();
        }
        ModuleEmiRecipe mr = (ModuleEmiRecipe)recipe;
        ModularInventory inv = ModuleRecipeHandler.getInventory(handler);
        if (inv == null) {
            return List.of();
        }
        ModuleRecipeHandler.setRecipe(inv.blockEntity, handler, mr);
        List<List<class_1735>> slotsPerSize = ModuleRecipeHandler.getInputSlots(handler, inv.inventory);
        if (mr.inputs.size() > slotsPerSize.size()) {
            return List.of();
        }
        return slotsPerSize.get(mr.inputs.size() - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() != IRIntegration.MODULES_CATEGORY) return false;
        if (!recipe.supportsRecipeTree()) return false;
        if (!(recipe instanceof ModuleEmiRecipe)) return false;
        ModuleEmiRecipe moduleRecipe = (ModuleEmiRecipe)recipe;
        if (moduleRecipe.inputs.size() > 6) return false;
        return true;
    }

    @Nullable
    private static ModularInventory getInventory(ModularWorkbenchScreenHandler handler) {
        Object t;
        Optional be;
        try {
            be = handler.getCtx().method_17395(class_1937::method_8321);
        }
        catch (NullPointerException e) {
            be = Optional.empty();
        }
        if (be.isEmpty() || !((t = be.get()) instanceof ModularWorkbenchBlockEntity)) {
            return null;
        }
        ModularWorkbenchBlockEntity wb = (ModularWorkbenchBlockEntity)t;
        InventoryComponent invComponent = wb.getInventoryComponent();
        if (invComponent == null) {
            return null;
        }
        IRInventory irInv = invComponent.getInventory();
        return new ModularInventory(wb, irInv);
    }

    private static void addCraftingInputs(ModularWorkbenchScreenHandler handler, IRInventory irInv, List<class_1735> inputs) {
        int slotCount = handler.field_7761.size();
        for (int i = 0; i < slotCount; ++i) {
            ValidatedSlot vSlot;
            int invIndex;
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (slot.field_7871 != irInv || !(slot instanceof ValidatedSlot) || 3 > (invIndex = (vSlot = (ValidatedSlot)slot).getInventoryIndex()) || invIndex >= 15) continue;
            inputs.add(slot);
        }
    }

    private static List<List<class_1735>> getInputSlots(ModularWorkbenchScreenHandler handler, IRInventory irInv) {
        ArrayList inputsList = Lists.newArrayList();
        ArrayList curInputs = Lists.newArrayList();
        int slotCount = handler.field_7761.size();
        for (int i = 0; i < slotCount; ++i) {
            ValidatedSlot vSlot;
            int invIndex;
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (slot.field_7871 != irInv || !(slot instanceof ValidatedSlot) || 3 > (invIndex = (vSlot = (ValidatedSlot)slot).getInventoryIndex()) || invIndex >= 15) continue;
            if (invIndex == 3 && !curInputs.isEmpty()) {
                inputsList.add(curInputs);
                curInputs = Lists.newArrayList();
            }
            curInputs.add(slot);
        }
        if (!curInputs.isEmpty()) {
            inputsList.add(curInputs);
        }
        inputsList.sort(Comparator.comparingInt(List::size));
        return inputsList;
    }

    private static void setRecipe(ModularWorkbenchBlockEntity be, ModularWorkbenchScreenHandler sh, ModuleEmiRecipe recipe) {
        WPanel wPanel;
        be.setSelectedRecipe(((ModuleRecipe)recipe.recipe).method_8114());
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(sh.field_7763);
        buf.method_10812(((ModuleRecipe)recipe.recipe).method_8114());
        buf.method_10807(be.method_11016());
        ClientPlayNetworking.send((class_2960)SelectModuleOnWorkbenchPacket.INSTANCE.getMODULE_SELECT_PACKET(), (class_2540)buf);
        if (TAB_PANEL_WIDGETS != null && (wPanel = sh.getRootPanel()) instanceof WCustomTabPanel) {
            WCustomTabPanel tabPanel = (WCustomTabPanel)wPanel;
            try {
                List tabs = (List)TAB_PANEL_WIDGETS.get(tabPanel);
                if (tabs.size() >= 2) {
                    ((WWidget)tabs.get(1)).onClick(0, 0, 0);
                } else {
                    ExMIMod.LOGGER.warn("[Extra Mod Integrations] Error setting Industrial Revolution Modular Workbench tab because the Modular Workbench is missing the crafting tab");
                }
            }
            catch (IllegalAccessException e) {
                ExMIMod.LOGGER.warn("[Extra Mod Integrations] Error setting Industrial Revolution Modular Workbench tab", (Throwable)e);
            }
        }
        sh.layoutSlots((ModuleRecipe)recipe.recipe);
        sh.getRootPanel().addPainters();
    }

    static {
        Field tabPanelWidgets;
        try {
            tabPanelWidgets = WCustomTabPanel.class.getDeclaredField("tabWidgets");
            tabPanelWidgets.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            tabPanelWidgets = null;
            ExMIMod.LOGGER.warn("[Extra Mod Integrations] Error getting access to Industrial Revolution Modular Workbench tab");
        }
        TAB_PANEL_WIDGETS = tabPanelWidgets;
    }

    private record ModularInventory(ModularWorkbenchBlockEntity blockEntity, IRInventory inventory) {
    }
}

