/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.render;

import com.google.common.collect.ImmutableMap;
import com.kyanite.deeperdarker.client.DDModelLayers;
import com.kyanite.deeperdarker.content.entities.DDBoat;
import com.kyanite.deeperdarker.content.entities.DDBoatLike;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class DDBoatRenderer
extends class_897 {
    private final boolean HAS_CHEST;
    private final Map<DDBoat.Type, class_4595<class_1690>> BOAT_RESOURCES;
    private final Map<DDBoat.Type, class_5601> chestBoatModels;
    private final Map<DDBoat.Type, class_5601> boatModels;

    public DDBoatRenderer(class_5617.class_5618 pContext, boolean pChestBoat) {
        super(pContext);
        this.HAS_CHEST = pChestBoat;
        this.chestBoatModels = Map.of(DDBoat.Type.ECHO, DDModelLayers.ECHO_CHEST_BOAT, DDBoat.Type.BLOOM, DDModelLayers.BLOOM_CHEST_BOAT);
        this.boatModels = Map.of(DDBoat.Type.ECHO, DDModelLayers.ECHO_BOAT, DDBoat.Type.BLOOM, DDModelLayers.BLOOM_BOAT);
        this.BOAT_RESOURCES = ImmutableMap.of((Object)((Object)DDBoat.Type.ECHO), this.createBoatModel(pContext, DDBoat.Type.ECHO), (Object)((Object)DDBoat.Type.BLOOM), this.createBoatModel(pContext, DDBoat.Type.BLOOM));
    }

    private static class_2960 getTexture(DDBoat.Type type, boolean chest) {
        if (chest) {
            return new class_2960("deeperdarker", "textures/entity/chest_boat/" + type.getName() + ".png");
        }
        return new class_2960("deeperdarker", "textures/entity/boat/" + type.getName() + ".png");
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 context, DDBoat.Type type) {
        class_5601 entityModelLayer = this.HAS_CHEST ? this.chestBoatModels.get((Object)type) : this.boatModels.get((Object)type);
        class_630 modelPart = context.method_32167(entityModelLayer);
        return this.HAS_CHEST ? new class_7752(modelPart) : new class_554(modelPart);
    }

    public void method_3936(class_1297 entity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        class_1690 boatEntity = (class_1690)entity;
        class_4595<class_1690> model = this.BOAT_RESOURCES.get((Object)((DDBoatLike)boatEntity).getWoodType());
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.375f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - f));
        float h = (float)boatEntity.method_7533() - g;
        float j = boatEntity.method_7554() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)boatEntity.method_7543()));
        }
        if (!class_3532.method_15347((float)boatEntity.method_7547(g), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().setAngleAxis(boatEntity.method_7547(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        model.method_2819((class_1297)boatEntity, g, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(model.method_23500(DDBoatRenderer.getTexture(((DDBoatLike)boatEntity).getWoodType(), this.HAS_CHEST)));
        model.method_2828(poseStack, vertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boatEntity.method_5869()) {
            class_4588 vertexConsumer2 = multiBufferSource.getBuffer(class_1921.method_23589());
            if (model instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)model;
                waterPatchModel.method_22954().method_22698(poseStack, vertexConsumer2, i, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        super.method_3936(entity, f, g, poseStack, multiBufferSource, i);
    }

    public class_2960 method_3931(class_1297 entity) {
        DDBoat.Type type;
        if (entity instanceof DDBoatLike) {
            DDBoatLike boat = (DDBoatLike)entity;
            type = boat.getWoodType();
        } else {
            type = DDBoat.Type.ECHO;
        }
        return DDBoatRenderer.getTexture(type, this.HAS_CHEST);
    }
}

