/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client.gui;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.client.gui.InvitationSetup;
import dev.ftb.mods.ftbteams.client.gui.InvitedButton;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.net.CreatePartyMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_332;
import net.minecraft.class_5251;

public class CreatePartyScreen
extends BaseScreen
implements NordColors,
InvitationSetup {
    private final ClientTeamManager manager;
    private final Set<GameProfile> invitedMembers;
    private Panel invitePanel;
    private Panel settingsPanel;
    private Button createTeamButton;
    private Color4I teamColor;
    private TextBox nameTextBox;
    private TextBox descriptionTextBox;

    public CreatePartyScreen() {
        this.setSize(300, 200);
        this.manager = FTBTeamsAPI.api().getClientManager();
        this.invitedMembers = new HashSet<GameProfile>();
        this.teamColor = this.manager.selfTeam().getProperty(TeamProperties.COLOR);
    }

    public void addWidgets() {
        SimpleButton closeButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.cancel"), Icons.CANCEL.withTint(SNOW_STORM_2), (simpleButton, mouseButton) -> this.closeGui()){

            public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                this.drawIcon(graphics, theme, x, y, w, h);
            }
        };
        this.add((Widget)closeButton);
        SimpleButton colorButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.color"), this.teamColor.withBorder(POLAR_NIGHT_0, false), (simpleButton, mouseButton) -> {
            this.teamColor = FTBTUtils.randomColor();
            simpleButton.setIcon(this.teamColor.withBorder(POLAR_NIGHT_0, false));
        }){

            public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                this.icon.draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)colorButton);
        this.invitePanel = new InvitePanel();
        this.add((Widget)this.invitePanel);
        this.settingsPanel = new SettingsPanel();
        this.add((Widget)this.settingsPanel);
        this.createTeamButton = new NordButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbteams.create_party").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)NordColors.GREEN.rgb()))), Icons.ACCEPT){

            public boolean renderTitleInCenter() {
                return true;
            }

            public void onClicked(MouseButton mouseButton) {
                this.closeGui(false);
                new CreatePartyMessage(CreatePartyScreen.this.nameTextBox.getText(), CreatePartyScreen.this.descriptionTextBox.getText(), CreatePartyScreen.this.teamColor.rgb(), CreatePartyScreen.this.invitedMembers).sendToServer();
            }
        };
        this.add((Widget)this.createTeamButton);
        closeButton.setPosAndSize(this.width - 18, 5, 12, 12);
        colorButton.setPosAndSize(5, 5, 12, 12);
        this.invitePanel.setPosAndSize(1, 22, 89, this.height - 23);
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((class_332)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)POLAR_NIGHT_0, (boolean)true);
        POLAR_NIGHT_1.draw(graphics, x + 1, y + 1, w - 2, h - 2);
        POLAR_NIGHT_0.draw(graphics, x + 1, y + 21, w - 2, 1);
        POLAR_NIGHT_0.draw(graphics, x + this.invitePanel.width + 1, y + this.invitePanel.posY, 1, this.invitePanel.height);
    }

    public void drawForeground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(graphics, theme, x, y, w, h);
        theme.drawString(graphics, (Object)class_2561.method_43471((String)"ftbteams.create_party"), x + w / 2, y + 7, SNOW_STORM_1, 4);
    }

    public boolean keyPressed(Key key) {
        return super.keyPressed(key);
    }

    @Override
    public boolean isInvited(GameProfile profile) {
        return this.invitedMembers.contains(profile);
    }

    @Override
    public void setInvited(GameProfile profile, boolean invited) {
        if (invited) {
            this.invitedMembers.add(profile);
        } else {
            this.invitedMembers.remove(profile);
        }
    }

    private class InvitePanel
    extends Panel {
        public InvitePanel() {
            super((Panel)CreatePartyScreen.this);
        }

        public void addWidgets() {
            this.add((Widget)new TextField((Panel)this).addFlags(4).setText((class_2561)class_2561.method_43471((String)"ftbteams.gui.add_members")));
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 2));
            class_320 self = class_310.method_1551().method_1548();
            this.add((Widget)new NordButton(this, (class_2561)class_2561.method_43470((String)"\u2726 ").method_27692(class_124.field_1065).method_27693(self.method_1676()), (Icon)FaceIcon.getFace((GameProfile)self.method_1677())){

                public void onClicked(MouseButton mouseButton) {
                }
            });
            CreatePartyScreen.this.manager.knownClientPlayers().stream().filter(kcp -> kcp.isOnlineAndNotInParty() && !kcp.equals(CreatePartyScreen.this.manager.self())).sorted().forEach(kcp -> this.add((Widget)new InvitedButton(this, CreatePartyScreen.this, (KnownClientPlayer)kcp)));
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(4, 2, 1));
            this.width = 80;
            for (Widget widget : this.widgets) {
                this.width = Math.max(this.width, widget.width);
            }
            for (Widget widget : this.widgets) {
                widget.setX(1);
                widget.setWidth(this.width - 2);
            }
            CreatePartyScreen.this.settingsPanel.setPosAndSize(this.width + 3, 23, CreatePartyScreen.this.width - CreatePartyScreen.this.invitePanel.width - 5, CreatePartyScreen.this.height - 40);
            CreatePartyScreen.this.createTeamButton.setPosAndSize(CreatePartyScreen.this.settingsPanel.posX, CreatePartyScreen.this.height - 15, CreatePartyScreen.this.settingsPanel.width, 13);
        }
    }

    private class SettingsPanel
    extends Panel {
        public SettingsPanel() {
            super((Panel)CreatePartyScreen.this);
        }

        public void addWidgets() {
            this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 6).setText((class_2561)class_2561.method_43471((String)"ftbteams.gui.party_name")));
            CreatePartyScreen.this.nameTextBox = new TextBox(this){

                public void drawTextBox(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                    NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
                }
            };
            this.add((Widget)CreatePartyScreen.this.nameTextBox);
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 4));
            this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 6).setText((class_2561)class_2561.method_43471((String)"ftbteams.gui.party_description")));
            CreatePartyScreen.this.descriptionTextBox = new TextBox(this){

                public void drawTextBox(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                    NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
                }
            };
            this.add((Widget)CreatePartyScreen.this.descriptionTextBox);
            this.add((Widget)new VerticalSpaceWidget((Panel)this, 4));
            CreatePartyScreen.this.nameTextBox.setHeight(14);
            CreatePartyScreen.this.nameTextBox.ghostText = class_310.method_1551().method_1548().method_1676() + "'s Team";
            CreatePartyScreen.this.descriptionTextBox.setHeight(14);
            CreatePartyScreen.this.descriptionTextBox.ghostText = "<None>";
        }

        public void alignWidgets() {
            for (Widget w : this.widgets) {
                w.setX(3);
                w.setWidth(this.width - 6);
            }
            this.align((WidgetLayout)new WidgetLayout.Vertical(3, 3, 10));
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_2.draw(graphics, x, y, w, h);
        }
    }
}

