/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.pipes.PipeBlock;
import earth.terrarium.adastra.common.blocks.pipes.TransferablePipe;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public interface Pipe {
    default public void findNodes(class_3218 level, class_2338 startPos) {
        LongOpenHashSet visitedNodes = new LongOpenHashSet();
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        queue.enqueue(startPos.method_10063());
        while (!queue.isEmpty()) {
            long currentPosLong = queue.dequeueLong();
            class_2338 pipePos = class_2338.method_10092((long)currentPosLong);
            class_2586 class_25862 = level.method_8321(pipePos);
            if (!(class_25862 instanceof PipeBlockEntity)) continue;
            PipeBlockEntity pipeEntity = (PipeBlockEntity)class_25862;
            class_2680 pipeState = pipeEntity.method_11010();
            class_2350[] directions = pipeEntity.connectedDirections();
            if (directions == null) continue;
            for (class_2350 direction : directions) {
                class_2338 pos = pipePos.method_10093(direction);
                long longPos = pos.method_10063();
                if (!visitedNodes.add(longPos)) continue;
                if (level.method_8320(pos).method_26204() instanceof TransferablePipe) {
                    queue.enqueue(longPos);
                    continue;
                }
                class_2586 entity = level.method_8321(pos);
                if (entity == null || !this.isValid(entity, direction)) continue;
                this.addNode(entity, (PipeProperty)((Object)pipeState.method_11654((class_2769)PipeBlock.DIRECTION_TO_CONNECTION.get(direction))), direction, pos);
            }
        }
    }

    public void addNode(@NotNull class_2586 var1, PipeProperty var2, class_2350 var3, class_2338 var4);

    default public void transfer(class_3218 level, long transferRate, Map<class_2338, class_2350> sources, Map<class_2338, class_2350> consumers) {
        for (Map.Entry<class_2338, class_2350> sourceEntry : sources.entrySet()) {
            class_2586 sourceEntity = level.method_8321(sourceEntry.getKey());
            if (sourceEntity == null || !this.isValid(sourceEntity, sourceEntry.getValue())) {
                return;
            }
            long rate = transferRate / (long)consumers.size();
            for (Map.Entry<class_2338, class_2350> consumerEntry : consumers.entrySet()) {
                class_2338 pos = consumerEntry.getKey();
                class_2350 direction = consumerEntry.getValue();
                class_2586 consumerEntity = level.method_8321(pos);
                if (consumerEntity == null || !this.isValid(consumerEntity, direction)) continue;
                this.moveContents(rate, sourceEntity, consumerEntity, direction);
            }
        }
    }

    public void moveContents(long var1, @NotNull class_2586 var3, @NotNull class_2586 var4, class_2350 var5);

    public boolean isValid(@NotNull class_2586 var1, class_2350 var2);
}

