/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.RecipeMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.container.BiFluidContainer;
import earth.terrarium.adastra.common.menus.machines.FuelRefineryMenu;
import earth.terrarium.adastra.common.recipes.machines.RefiningRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

public class FuelRefineryBlockEntity
extends RecipeMachineBlockEntity<RefiningRecipe>
implements BotariumFluidBlock<WrappedBlockFluidContainer> {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_EXTRACTION_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_FLUID), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    private WrappedBlockFluidContainer fluidContainer;

    public FuelRefineryBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 5, ModRecipeTypes.REFINING);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new FuelRefineryMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.steelTierEnergyCapacity, MachineConfig.steelTierMaxEnergyInOut));
        return this.energyContainer;
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        if (this.fluidContainer != null) {
            return this.fluidContainer;
        }
        this.fluidContainer = new WrappedBlockFluidContainer((class_2586)this, (FluidContainer)new BiFluidContainer(FluidConstants.fromMillibuckets((long)MachineConfig.steelTierFluidCapacity), 1, 1, (tank, holder) -> this.level().method_8433().method_30027((class_3956)ModRecipeTypes.REFINING.get()).stream().anyMatch(r -> r.input().test(holder)), (tank, holder) -> this.level().method_8433().method_30027((class_3956)ModRecipeTypes.REFINING.get()).stream().anyMatch(r -> r.result().matches(holder))));
        return this.fluidContainer;
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby(this, pos, new int[]{3}, sideConfig.get(1), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{2, 4}, sideConfig.get(2), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(3), filter);
        TransferUtils.pullFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 0, sideConfig.get(4), filter);
        TransferUtils.pushFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 1, sideConfig.get(5), filter);
    }

    @Override
    public void recipeTick(class_3218 level, WrappedBlockEnergyContainer energyStorage) {
        if (this.recipe == null) {
            return;
        }
        if (this.fluidContainer == null) {
            this.getFluidContainer();
        }
        if (!this.canCraft()) {
            this.clearRecipe();
            return;
        }
        energyStorage.internalExtract((long)((RefiningRecipe)this.recipe).energy(), false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craft();
    }

    @Override
    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.fluidContainer.internalExtract(this.getFluidContainer().getFirstFluid().copyWithAmount(((RefiningRecipe)this.recipe).input().getFluidAmount()), false);
        this.fluidContainer.internalInsert(((RefiningRecipe)this.recipe).result(), false);
        this.updateSlots();
        this.cookTime = 0;
        if (this.fluidContainer.getFirstFluid().isEmpty()) {
            this.clearRecipe();
        }
    }

    @Override
    public void update() {
        this.quickCheck.method_42303((class_1263)this, this.level()).ifPresent(r -> {
            this.recipe = r;
            this.cookTimeTotal = r.cookingTime();
        });
        this.updateSlots();
    }

    @Override
    public void updateSlots() {
        FluidUtils.moveItemToContainer(this, (FluidContainer)this.fluidContainer, 1, 2, 0);
        FluidUtils.moveContainerToItem(this, (FluidContainer)this.fluidContainer, 3, 4, 1);
        this.sync();
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[]{1, 2, 3, 4};
    }
}

