/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.client;

import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.client.ClientFinalProcessor;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.client.MessageFlow;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.client.ServerFirstProcessor;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ClientFinalMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ClientFirstMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.Gs2CbindFlag;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramFunctions;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ServerFinalMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.ServerFirstMessage;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScramClient
implements MessageFlow {
    private final ScramMechanism scramMechanism;
    private final Gs2CbindFlag channelBinding;
    private final StringPreparation stringPreparation;
    private final String username;
    private final char[] password;
    private final byte[] saltedPassword;
    private final byte[] clientKey;
    private final byte[] serverKey;
    private final String cbindType;
    private final byte[] cbindData;
    private final String authzid;
    private final String nonce;
    private MessageFlow.Stage currentState = MessageFlow.Stage.NONE;
    private ClientFirstMessage clientFirstMessage;
    private ServerFirstProcessor serverFirstProcessor;
    private ClientFinalProcessor clientFinalProcessor;

    private ScramClient(@NotNull Builder builder) {
        this.channelBinding = builder.channelBinding;
        this.scramMechanism = builder.selectedScramMechanism;
        this.stringPreparation = builder.stringPreparation;
        this.username = builder.username;
        this.password = builder.password != null ? (char[])builder.password.clone() : null;
        this.saltedPassword = builder.saltedPassword;
        this.clientKey = builder.clientKey;
        this.serverKey = builder.serverKey;
        this.nonce = builder.nonce;
        this.cbindType = builder.cbindType;
        this.cbindData = builder.cbindData;
        this.authzid = builder.authzid;
    }

    public ScramMechanism getScramMechanism() {
        return this.scramMechanism;
    }

    @Override
    public ClientFirstMessage clientFirstMessage() {
        if (this.currentState != MessageFlow.Stage.NONE) {
            throw new IllegalStateException("Invalid state for processing client first message");
        }
        this.clientFirstMessage = new ClientFirstMessage(this.channelBinding, this.cbindType, this.authzid, this.username, this.nonce);
        this.currentState = MessageFlow.Stage.CLIENT_FIRST;
        return this.clientFirstMessage;
    }

    @Override
    public ServerFirstMessage serverFirstMessage(String serverFirstMessage) throws ScramParseException {
        if (this.currentState != MessageFlow.Stage.CLIENT_FIRST) {
            throw new IllegalStateException("Invalid state for processing server first message");
        }
        Preconditions.checkNotEmpty(serverFirstMessage, "serverFirstMessage");
        this.serverFirstProcessor = new ServerFirstProcessor(this.scramMechanism, this.stringPreparation, serverFirstMessage, this.nonce, this.clientFirstMessage);
        this.currentState = MessageFlow.Stage.SERVER_FIRST;
        return this.serverFirstProcessor.getServerFirstMessage();
    }

    @Override
    public ClientFinalMessage clientFinalMessage() {
        if (this.currentState != MessageFlow.Stage.SERVER_FIRST || this.serverFirstProcessor == null) {
            throw new IllegalStateException("Invalid state for processing client final message");
        }
        if (this.password != null) {
            this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.password);
            Arrays.fill(this.password, '\u0000');
        } else if (this.saltedPassword != null) {
            this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.saltedPassword);
        } else if (this.clientKey != null && this.serverKey != null) {
            this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.clientKey, this.serverKey);
        }
        ClientFinalMessage clientFinalMessage = this.clientFinalProcessor.clientFinalMessage(this.cbindData);
        this.currentState = MessageFlow.Stage.CLIENT_FINAL;
        return clientFinalMessage;
    }

    @Override
    public ServerFinalMessage serverFinalMessage(String serverFinalMessage) throws ScramParseException, ScramServerErrorException, ScramInvalidServerSignatureException {
        if (this.currentState != MessageFlow.Stage.CLIENT_FINAL || this.clientFinalProcessor == null) {
            throw new IllegalStateException("Invalid state for processing server final message");
        }
        ServerFinalMessage receiveServerFinalMessage = this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        this.currentState = MessageFlow.Stage.SERVER_FINAL;
        return receiveServerFinalMessage;
    }

    public static MechanismsBuildStage builder() {
        return new Builder();
    }

    static final class Builder
    implements MechanismsBuildStage,
    UsernameBuildStage,
    PasswordBuildStage,
    FinalBuildStage {
        ScramMechanism selectedScramMechanism;
        Collection<String> scramMechanisms;
        Gs2CbindFlag channelBinding = Gs2CbindFlag.CLIENT_NOT;
        StringPreparation stringPreparation = StringPreparation.SASL_PREPARATION;
        int nonceLength = 24;
        String nonce;
        SecureRandom secureRandom;
        String username;
        char[] password;
        byte[] saltedPassword;
        byte[] clientKey;
        byte[] serverKey;
        String cbindType;
        byte[] cbindData;
        String authzid;
        Supplier<String> nonceSupplier;

        private Builder() {
        }

        @Override
        public FinalBuildStage stringPreparation(@NotNull StringPreparation stringPreparation) {
            this.stringPreparation = Preconditions.checkNotNull(stringPreparation, "stringPreparation");
            return this;
        }

        @Override
        public FinalBuildStage channelBinding(@Nullable String cbindType, byte @Nullable [] cbindData) {
            this.cbindType = cbindType;
            this.cbindData = cbindData != null ? (byte[])cbindData.clone() : null;
            this.channelBinding = cbindType != null && cbindData != null && !cbindType.isEmpty() && cbindData.length > 0 ? Gs2CbindFlag.CLIENT_YES_SERVER_NOT : Gs2CbindFlag.CLIENT_NOT;
            return this;
        }

        @Override
        public FinalBuildStage authzid(@NotNull String authzid) {
            this.authzid = Preconditions.checkNotEmpty(authzid, "authzid");
            return this;
        }

        @Override
        public PasswordBuildStage username(@NotNull String username) {
            this.username = Preconditions.checkNotEmpty(username, "username");
            return this;
        }

        @Override
        public FinalBuildStage password(char @NotNull [] password) {
            this.password = Preconditions.checkNotEmpty(password, "password");
            return this;
        }

        @Override
        public FinalBuildStage saltedPassword(byte @NotNull [] saltedPassword) {
            this.saltedPassword = Preconditions.checkNotNull(saltedPassword, "saltedPassword");
            return this;
        }

        @Override
        public FinalBuildStage clientAndServerKey(byte @NotNull [] clientKey, byte @NotNull [] serverKey) {
            this.clientKey = Preconditions.checkNotNull(clientKey, "clientKey");
            this.serverKey = Preconditions.checkNotNull(serverKey, "serverKey");
            return this;
        }

        @Override
        public UsernameBuildStage advertisedMechanisms(@NotNull @NotNull Collection<@NotNull String> scramMechanisms) {
            Preconditions.checkNotNull(scramMechanisms, "scramMechanisms");
            Preconditions.checkArgument(!scramMechanisms.isEmpty(), "scramMechanisms");
            this.scramMechanisms = scramMechanisms;
            return this;
        }

        @Override
        public FinalBuildStage nonceLength(int length) {
            this.nonceLength = Preconditions.gt0(length, "length");
            return this;
        }

        @Override
        public FinalBuildStage nonceSupplier(@NotNull @NotNull Supplier<@NotNull String> nonceSupplier) {
            this.nonceSupplier = Preconditions.checkNotNull(nonceSupplier, "nonceSupplier");
            return this;
        }

        @Override
        public FinalBuildStage secureRandomAlgorithmProvider(@NotNull String algorithm, @Nullable String provider) {
            try {
                this.secureRandom = null == provider ? SecureRandom.getInstance(algorithm) : SecureRandom.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new IllegalArgumentException("Invalid algorithm or provider", ex);
            }
            return this;
        }

        @Override
        public ScramClient build() {
            SecureRandom random = this.secureRandom != null ? this.secureRandom : new SecureRandom();
            this.nonce = this.nonceSupplier != null ? this.nonceSupplier.get() : ScramFunctions.nonce(this.nonceLength, random);
            this.selectedScramMechanism = this.mechanismNegotiation();
            return new ScramClient(this);
        }

        private ScramMechanism mechanismNegotiation() {
            ScramMechanism mechanismNegotiaion;
            ScramMechanism cbind = Builder.selectMechanism(this.scramMechanisms, true);
            ScramMechanism noncbind = Builder.selectMechanism(this.scramMechanisms, false);
            ScramMechanism scramMechanism = mechanismNegotiaion = cbind != null ? cbind : noncbind;
            if (mechanismNegotiaion == null) {
                throw new IllegalArgumentException("Either a bare or plus mechanism must be present");
            }
            if (this.channelBinding == Gs2CbindFlag.CLIENT_YES_SERVER_NOT && mechanismNegotiaion.isPlus()) {
                this.channelBinding = Gs2CbindFlag.CHANNEL_BINDING_REQUIRED;
            } else {
                if (noncbind == null) {
                    throw new IllegalArgumentException("A non-PLUS mechanism was not advertised");
                }
                this.cbindType = null;
                this.cbindData = null;
                mechanismNegotiaion = noncbind;
            }
            if (this.channelBinding == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED && (this.cbindType == null || this.cbindData == null)) {
                throw new IllegalArgumentException("Channel Binding type and data are required");
            }
            return mechanismNegotiaion;
        }

        @Nullable
        private static ScramMechanism selectMechanism(@NotNull @NotNull Collection<@NotNull String> scramMechanisms, boolean channelBinding) {
            ScramMechanism selectedMechanism = null;
            for (String mechanism : scramMechanisms) {
                ScramMechanism candidateMechanism = ScramMechanism.byName(mechanism);
                if (candidateMechanism == null || candidateMechanism.isPlus() != channelBinding || selectedMechanism != null && candidateMechanism.ordinal() <= selectedMechanism.ordinal()) continue;
                selectedMechanism = candidateMechanism;
            }
            return selectedMechanism;
        }
    }

    public static interface FinalBuildStage {
        public FinalBuildStage channelBinding(@Nullable String var1, byte @Nullable [] var2);

        public FinalBuildStage stringPreparation(@NotNull StringPreparation var1);

        public FinalBuildStage authzid(@NotNull String var1);

        public FinalBuildStage nonceLength(int var1);

        public FinalBuildStage nonceSupplier(@NotNull @NotNull Supplier<@NotNull String> var1);

        public FinalBuildStage secureRandomAlgorithmProvider(@NotNull String var1, @Nullable String var2);

        public ScramClient build();
    }

    public static interface PasswordBuildStage {
        public FinalBuildStage password(char @NotNull [] var1);

        public FinalBuildStage saltedPassword(byte @NotNull [] var1);

        public FinalBuildStage clientAndServerKey(byte @NotNull [] var1, byte @NotNull [] var2);
    }

    public static interface UsernameBuildStage {
        public PasswordBuildStage username(@NotNull String var1);
    }

    public static interface MechanismsBuildStage {
        public UsernameBuildStage advertisedMechanisms(@NotNull @NotNull Collection<@NotNull String> var1);
    }
}

