/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.codec;

import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class DoubleCodec
implements Codec<Double> {
    public static final DoubleCodec INSTANCE = new DoubleCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.BIGINT, DataType.YEAR, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Double.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Double.TYPE || type.isAssignableFrom(Double.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Double;
    }

    @Override
    public Double decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return column.decodeDoubleText(buf, length);
    }

    @Override
    public Double decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return column.decodeDoubleBinary(buf, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public int getApproximateTextProtocolLength(Object value, Long length) {
        return value.toString().length();
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeDouble((Double)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DOUBLE.get();
    }
}

