/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.impl;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.HostAddress;
import com.vecoo.extralib.shade.mariadb.jdbc.Statement;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Completion;
import com.vecoo.extralib.shade.mariadb.jdbc.client.context.RedoContext;
import com.vecoo.extralib.shade.mariadb.jdbc.client.impl.StandardClient;
import com.vecoo.extralib.shade.mariadb.jdbc.client.impl.TransactionSaver;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.ClosableLock;
import com.vecoo.extralib.shade.mariadb.jdbc.export.MaxAllowedPacketException;
import com.vecoo.extralib.shade.mariadb.jdbc.export.Prepare;
import com.vecoo.extralib.shade.mariadb.jdbc.message.ClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.PreparePacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.RedoableClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.PrepareResultPacket;
import com.vecoo.extralib.shade.mariadb.jdbc.util.log.Logger;
import com.vecoo.extralib.shade.mariadb.jdbc.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class ReplayClient
extends StandardClient {
    private static final Logger logger = Loggers.getLogger(ReplayClient.class);

    public ReplayClient(Configuration conf, HostAddress hostAddress, ClosableLock lock, boolean skipPostCommands) throws SQLException {
        super(conf, hostAddress, lock, skipPostCommands);
    }

    @Override
    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (message instanceof RedoableClientMessage) {
                ((RedoableClientMessage)message).ensureReplayable(this.context);
            }
            return message.encode(this.writer, this.context);
        }
        catch (MaxAllowedPacketException maxE) {
            if (maxE.isMustReconnect()) {
                this.destroySocket();
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", maxE);
            }
            throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", maxE);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> res = super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(messages);
        return res;
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> completions = super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(message);
        return completions;
    }

    public void transactionReplay(TransactionSaver transactionSaver) throws SQLException {
        RedoableClientMessage[] buffers = transactionSaver.getBuffers();
        try {
            for (int i = 0; i < transactionSaver.getIdx(); ++i) {
                int responseNo;
                RedoableClientMessage querySaver = buffers[i];
                if (querySaver instanceof RedoableWithPrepareClientMessage) {
                    RedoableWithPrepareClientMessage redoable = (RedoableWithPrepareClientMessage)querySaver;
                    String cmd = redoable.getCommand();
                    Prepare prepare = this.context.getPrepareCacheCmd(cmd, redoable.prep());
                    if (prepare == null) {
                        PreparePacket preparePacket = new PreparePacket(cmd);
                        this.sendQuery(preparePacket);
                        prepare = (PrepareResultPacket)this.readPacket(preparePacket);
                        logger.info("replayed command after failover: " + preparePacket.description());
                    }
                    responseNo = querySaver.reEncode(this.writer, this.context, prepare);
                } else {
                    responseNo = querySaver.reEncode(this.writer, this.context, null);
                }
                logger.info("replayed command after failover: " + querySaver.description());
                for (int j = 0; j < responseNo; ++j) {
                    this.readResponse(querySaver);
                }
            }
        }
        catch (IOException e) {
            throw this.context.getExceptionFactory().create("Socket error during transaction replay", "08000", e);
        }
    }
}

