/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.column;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.column.BlobColumn;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Geometry;
import com.vecoo.extralib.shade.mariadb.jdbc.type.GeometryCollection;
import com.vecoo.extralib.shade.mariadb.jdbc.type.LineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiLineString;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiPoint;
import com.vecoo.extralib.shade.mariadb.jdbc.type.MultiPolygon;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Point;
import com.vecoo.extralib.shade.mariadb.jdbc.type.Polygon;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;

public class GeometryColumn
extends BlobColumn {
    public GeometryColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected GeometryColumn(GeometryColumn prev) {
        super(prev);
    }

    @Override
    public GeometryColumn useAliasAsName() {
        return new GeometryColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType())) {
            if (this.extTypeName != null) {
                switch (this.extTypeName) {
                    case "point": {
                        return Point.class.getName();
                    }
                    case "linestring": {
                        return LineString.class.getName();
                    }
                    case "polygon": {
                        return Polygon.class.getName();
                    }
                    case "multipoint": {
                        return MultiPoint.class.getName();
                    }
                    case "multilinestring": {
                        return MultiLineString.class.getName();
                    }
                    case "multipolygon": {
                        return MultiPolygon.class.getName();
                    }
                    case "geometrycollection": {
                        return GeometryCollection.class.getName();
                    }
                }
            }
            return GeometryCollection.class.getName();
        }
        return "byte[]";
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -3;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.extTypeName != null) {
            return this.extTypeName.toUpperCase(Locale.ROOT);
        }
        return "GEOMETRY";
    }

    @Override
    public Object getDefaultText(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        if (context.getConf().geometryDefaultType() != null && "default".equals(context.getConf().geometryDefaultType())) {
            buf.skip(4);
            return Geometry.getGeometry(buf, length.get() - 4, this);
        }
        byte[] arr = new byte[length.get()];
        buf.readBytes(arr);
        return arr;
    }

    @Override
    public Object getDefaultBinary(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return this.getDefaultText(buf, length, context);
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

