/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class LivingEntityBolt {
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;
    private final class_1309 shooter;

    public LivingEntityBolt(ShooterDataHolder data, class_1309 shooter, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
        this.shooter = shooter;
    }

    public void bolt() {
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem iGun = (AbstractGunItem)class_17922;
        class_2960 gunId = iGun.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            boolean noAmmo;
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.isBolting) {
                return;
            }
            IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            boolean useInventoryAmmo = iGun.useInventoryAmmo(currentGunItem);
            boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT;
            boolean hasInventoryAmmo = iGun.hasInventoryAmmo(this.shooter, currentGunItem, gunOperator.needCheckAmmo());
            boolean bl = noAmmo = useInventoryAmmo && !hasInventoryAmmo || !useInventoryAmmo && iGun.getCurrentAmmoCount(currentGunItem) < 1;
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (hasAmmoInBarrel) {
                return;
            }
            if (noAmmo) {
                return;
            }
            this.data.boltTimestamp = System.currentTimeMillis();
            this.data.isBolting = iGun.startBolt(this.data, currentGunItem, this.shooter);
        });
    }

    public void tickBolt() {
        if (!this.data.isBolting) {
            return;
        }
        if (this.data.currentGunItem == null) {
            this.data.isBolting = false;
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof AbstractGunItem)) {
            this.data.isBolting = false;
            return;
        }
        AbstractGunItem iGun = (AbstractGunItem)class_17922;
        class_2960 gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        this.data.isBolting = gunIndex.map(index -> iGun.tickBolt(this.data, currentGunItem, this.shooter)).orElse(false);
    }
}

