/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.controllable;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.IBindingContext;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.input.AimKey;
import com.tacz.guns.client.input.CrawlKey;
import com.tacz.guns.client.input.FireSelectKey;
import com.tacz.guns.client.input.InspectKey;
import com.tacz.guns.client.input.InteractKey;
import com.tacz.guns.client.input.MeleeKey;
import com.tacz.guns.client.input.ReloadKey;
import com.tacz.guns.client.input.ShootKey;
import com.tacz.guns.client.input.ZoomKey;
import com.tacz.guns.client.resource.pojo.display.gun.ControllableData;
import committee.nova.mkb.keybinding.KeyConflictContext;
import java.util.EnumMap;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ControllableInner {
    public static final IBindingContext GUN_KEY_CONFLICT = new GunKeyConflict();
    public static final ButtonBinding AIM = new ButtonBinding(11, "key.tacz.aim.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding SHOOT = new ButtonBinding(12, "key.tacz.shoot.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding RELOAD = new ButtonBinding(1, "key.tacz.reload.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding MELEE = new ButtonBinding(2, "key.tacz.melee.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding ZOOM = new ButtonBinding(2, "key.tacz.zoom.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding CRAWL = new ButtonBinding(7, "key.tacz.crawl.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding FIRE_SELECT = new ButtonBinding(15, "key.tacz.fire_select.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding INTERACT = new ButtonBinding(-1, "key.tacz.interact.desc", "key.category.tacz", GUN_KEY_CONFLICT);
    public static final ButtonBinding INSPECT = new ButtonBinding(-1, "key.tacz.inspect.desc", "key.category.tacz", GUN_KEY_CONFLICT);

    public static void init() {
        BindingRegistry.getInstance().register(AIM);
        BindingRegistry.getInstance().register(SHOOT);
        BindingRegistry.getInstance().register(RELOAD);
        BindingRegistry.getInstance().register(MELEE);
        BindingRegistry.getInstance().register(CRAWL);
        BindingRegistry.getInstance().register(ZOOM);
        BindingRegistry.getInstance().register(FIRE_SELECT);
        BindingRegistry.getInstance().register(INTERACT);
        BindingRegistry.getInstance().register(INSPECT);
        ControllerEvents.INPUT.register((IFrameworkEvent)((ControllerEvents.Input)ControllableInner::onButtonInput));
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)ControllableInner::onClientTickEnd));
    }

    public static boolean onButtonInput(Controller controller, Value<Integer> newButton, int originalButton, boolean isPress) {
        if (!GUN_KEY_CONFLICT.isActive()) {
            return false;
        }
        if (AIM.getButton() == ((Integer)newButton.get()).intValue() && AimKey.onAimControllerPress(isPress)) {
            return true;
        }
        if (SHOOT.getButton() == ((Integer)newButton.get()).intValue() && ShootKey.semiShootController(isPress)) {
            ControllableInner.doRumble(controller);
            return true;
        }
        if (RELOAD.getButton() == ((Integer)newButton.get()).intValue() && ReloadKey.onReloadControllerPress(isPress)) {
            return true;
        }
        if (MELEE.getButton() == ((Integer)newButton.get()).intValue() && MeleeKey.onMeleeControllerPress(isPress)) {
            return true;
        }
        if (CRAWL.getButton() == ((Integer)newButton.get()).intValue() && CrawlKey.onCrawlControllerPress(isPress)) {
            return true;
        }
        if (ZOOM.getButton() == ((Integer)newButton.get()).intValue() && ZoomKey.onZoomControllerPress(isPress)) {
            return true;
        }
        if (FIRE_SELECT.getButton() == ((Integer)newButton.get()).intValue() && FireSelectKey.onFireSelectControllerPress(isPress)) {
            return true;
        }
        if (INTERACT.getButton() == ((Integer)newButton.get()).intValue() && InteractKey.onInteractControllerPress(isPress)) {
            return true;
        }
        return INSPECT.getButton() == ((Integer)newButton.get()).intValue() && InspectKey.onInspectControllerPress(isPress);
    }

    public static void onClientTickEnd() {
        if (!GUN_KEY_CONFLICT.isActive()) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (controller.isButtonPressed(SHOOT.getButton()) && ShootKey.autoShootController()) {
            ControllableInner.doRumble(controller);
        }
    }

    private static void doRumble(Controller controller) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 mainHandItem = player.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return;
        }
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(index -> {
            EnumMap<FireMode, ControllableData> data = index.getControllableData();
            if (data.containsKey((Object)fireMode)) {
                ControllableData controllableData = data.get((Object)fireMode);
                controller.rumble(controllableData.getLowFrequency(), controllableData.getHighFrequency(), controllableData.getTimeInMs());
            } else if (fireMode == FireMode.AUTO) {
                controller.rumble(0.15f, 0.25f, 80);
            } else {
                controller.rumble(0.25f, 0.5f, 100);
            }
        });
    }

    public static class GunKeyConflict
    implements IBindingContext {
        public boolean isActive() {
            class_746 player = class_310.method_1551().field_1724;
            return !KeyConflictContext.GUI.isActive() && player != null && IGun.mainHandHoldGun((class_1309)player);
        }

        public boolean conflicts(IBindingContext other) {
            return this == other;
        }
    }
}

