/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.RenderTickEvent;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.renderer.crosshair.CrosshairType;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.config.client.RenderConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_636;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class RenderCrosshairEvent {
    private static final class_2960 HIT_ICON = new class_2960("tacz", "textures/crosshair/hit/hit_marker.png");
    private static final long KEEP_TIME = 300L;
    private static boolean isRefitScreen = false;
    private static long hitTimestamp = -1L;
    private static long killTimestamp = -1L;
    private static long headShotTimestamp = -1L;

    public static void onRenderOverlay(class_332 guiGraphics, class_1041 window) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!IGun.mainHandHoldGun((class_1309)player)) {
            return;
        }
        RenderCrosshairEvent.renderHitMarker(guiGraphics, window);
        ReloadState reloadState = IGunOperator.fromLivingEntity((class_1309)player).getSynReloadState();
        if (reloadState.getStateType().isReloading()) {
            return;
        }
        if (isRefitScreen) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }
        IClientPlayerGunOperator playerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
        TimelessAPI.getGunDisplay(stack).ifPresent(gunIndex -> {
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine;
            Object context;
            if ((double)playerGunOperator.getClientAimingProgress(class_310.method_1551().method_1488()) > 0.9) {
                boolean forceShow = gunIndex.isShowCrosshair();
                boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
                if (!forceShow && !shoulderSurfingForceShow) {
                    return;
                }
            }
            if ((context = (animationStateMachine = gunIndex.getAnimationStateMachine()).getContext()) == null || !((AnimationStateContext)context).shouldHideCrossHair()) {
                RenderCrosshairEvent.renderCrosshair(guiGraphics, window);
            }
        });
    }

    public static void onRenderTick(RenderTickEvent event) {
        isRefitScreen = class_310.method_1551().field_1755 instanceof GunRefitScreen;
    }

    private static void renderCrosshair(class_332 graphics, class_1041 window) {
        class_315 options = class_310.method_1551().field_1690;
        boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
        if (!options.method_31044().method_31034() && !shoulderSurfingForceShow) {
            return;
        }
        if (options.field_1842) {
            return;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return;
        }
        if (gameMode.method_2920() == class_1934.field_9219) {
            return;
        }
        int width = window.method_4486();
        int height = window.method_4502();
        class_2960 location = CrosshairType.getTextureLocation((CrosshairType)((Object)RenderConfig.CROSSHAIR_TYPE.get()));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        graphics.method_25290(location, (int)x, (int)y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static void renderHitMarker(class_332 graphics, class_1041 window) {
        float fadeTime;
        long remainHitTime = System.currentTimeMillis() - hitTimestamp;
        long remainKillTime = System.currentTimeMillis() - killTimestamp;
        long remainHeadShotTime = System.currentTimeMillis() - headShotTimestamp;
        float offset = ((Double)RenderConfig.HIT_MARKET_START_POSITION.get()).floatValue();
        if (remainKillTime > 300L) {
            if (remainHitTime > 300L) {
                return;
            }
            fadeTime = remainHitTime;
        } else {
            offset += (float)remainKillTime * 4.0f / 300.0f;
            fadeTime = remainKillTime;
        }
        int width = window.method_4486();
        int height = window.method_4502();
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        if (remainHeadShotTime > 300L) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - fadeTime / 300.0f));
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)(1.0f - fadeTime / 300.0f));
        }
        graphics.method_25290(HIT_ICON, (int)(x - offset), (int)(y - offset), 0.0f, 0.0f, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int)(x + 8.0f + offset), (int)(y - offset), 8.0f, 0.0f, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int)(x - offset), (int)(y + 8.0f + offset), 0.0f, 8.0f, 8, 8, 16, 16);
        graphics.method_25290(HIT_ICON, (int)(x + 8.0f + offset), (int)(y + 8.0f + offset), 8.0f, 8.0f, 8, 8, 16, 16);
    }

    public static void markHitTimestamp() {
        hitTimestamp = System.currentTimeMillis();
    }

    public static void markKillTimestamp() {
        killTimestamp = System.currentTimeMillis();
    }

    public static void markHeadShotTimestamp() {
        headShotTimestamp = System.currentTimeMillis();
    }
}

