/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.sealconfig;

import com.focamacho.sealconfig.ConfigObject;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.Jankson;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.element.JsonElement;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.element.JsonObject;
import com.focamacho.sealconfig.relocated.org.apache.commons.text.translate.UnicodeUnescaper;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class SealConfig {
    protected static final Logger logger = Logger.getLogger("SealConfig");
    protected static final UnicodeUnescaper unicodeUnescaper = new UnicodeUnescaper();
    protected final Map<Class<?>, Map<File, Object>> configs = new HashMap();

    public <T> T getConfig(File configFile, Class<T> classe) {
        Map<File, Object> configs = this.configs.get(classe);
        if (configs == null) {
            return this.createConfig(configFile, classe);
        }
        Object config = configs.get(configFile);
        if (config == null) {
            return this.createConfig(configFile, classe);
        }
        return (T)config;
    }

    public void reload() {
        this.configs.forEach((classe, map) -> map.forEach((file, object) -> this.createConfig((File)file, (Class)classe)));
    }

    public void save() {
        this.configs.forEach((classe, map) -> map.forEach((file, object) -> this.save(object)));
    }

    public void save(Object configObject) {
        this.configs.forEach((classe, map) -> map.forEach((file, object) -> {
            if (configObject == object) {
                try {
                    String toSave = unicodeUnescaper.translate(Jankson.builder().build().load(Jankson.builder().build().toJson(configObject).toJson(true, true, 0)).toJson(true, true, 0, 2));
                    if (!file.exists()) {
                        boolean mk = file.getParentFile().mkdirs();
                        boolean bl = file.createNewFile();
                    }
                    FileUtils.write(file, (CharSequence)toSave, StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    logger.severe("Erro ao salvar um arquivo de configura\u00e7\u00e3o:");
                    e.printStackTrace();
                }
            }
        }));
    }

    private <T> T createConfig(File configFile, Class<T> configClass) {
        try {
            JsonObject configObject;
            JsonObject defaults = Jankson.builder().build().load(Jankson.builder().build().toJson(configClass.newInstance()).toJson(true, true, 0));
            if (!configFile.exists()) {
                boolean mk = configFile.getParentFile().mkdirs();
                boolean nf = configFile.createNewFile();
                configObject = defaults;
            } else {
                configObject = Jankson.builder().build().load(configFile);
                configObject = this.checkValues(defaults, configObject, configClass);
            }
            FileUtils.write(configFile, (CharSequence)unicodeUnescaper.translate(configObject.toJson(true, true, 0, 2)), StandardCharsets.UTF_8);
            T config = Jankson.builder().build().fromJson(configObject.toJson(), configClass);
            Map<File, Object> configs = this.configs.get(configClass);
            if (configs == null) {
                this.configs.put(configClass, new HashMap());
                configs = this.configs.get(configClass);
            }
            if (configs.get(configFile) == null) {
                configs.put(configFile, config);
            } else {
                this.setValues(configs.get(configFile), config);
            }
            return config;
        }
        catch (Exception e) {
            logger.severe("Erro ao carregar um arquivo de configura\u00e7\u00e3o:");
            e.printStackTrace();
            return null;
        }
    }

    private void setValues(Object configObject, Object newObject) {
        try {
            for (Field field : configObject.getClass().getFields()) {
                for (Field newField : newObject.getClass().getFields()) {
                    if (!field.getName().equalsIgnoreCase(newField.getName())) continue;
                    if (field.isAnnotationPresent(ConfigObject.class)) {
                        this.setValues(field.get(configObject), newField.get(newObject));
                        continue;
                    }
                    field.set(configObject, newField.get(newObject));
                }
            }
        }
        catch (Exception e) {
            logger.severe("Erro ao definir os valores em um objeto de configura\u00e7\u00e3o:");
            e.printStackTrace();
        }
    }

    private JsonObject checkValues(JsonObject defaultObject, JsonObject actualObject, Class<?> configClass) {
        for (Map.Entry<String, JsonElement> entry : defaultObject.entrySet()) {
            if (!actualObject.containsKey(entry.getKey())) {
                actualObject = this.applyDefaults(defaultObject, actualObject);
                continue;
            }
            if (!(actualObject.get(entry.getKey()) instanceof JsonObject)) continue;
            try {
                Field field = configClass.getDeclaredField(entry.getKey());
                if (!field.isAnnotationPresent(ConfigObject.class)) continue;
                actualObject.put(entry.getKey(), this.checkValues((JsonObject)entry.getValue(), actualObject.getObject(entry.getKey()), field.getType()));
            }
            catch (Exception exception) {}
        }
        for (Map.Entry<String, JsonElement> entry : defaultObject.entrySet()) {
            actualObject.setComment(entry.getKey(), defaultObject.getComment(entry.getKey()));
        }
        return actualObject;
    }

    private JsonObject applyDefaults(JsonObject defaultObject, JsonObject actualObject) {
        JsonObject newObject = defaultObject.clone();
        actualObject.forEach((key, value) -> {
            if (newObject.containsKey(key)) {
                newObject.put((String)key, (JsonElement)value);
            }
        });
        return newObject;
    }

    private void removeClassDefaults(Object config, JsonObject configObject) {
        try {
            Field[] fields;
            for (Field field : fields = config.getClass().getFields()) {
                JsonObject jsonObject = configObject.getObject(field.getName());
                if (jsonObject == null) continue;
                Object obj = field.get(config);
                if (field.isAnnotationPresent(ConfigObject.class)) {
                    if (!configObject.containsKey(field.getName())) continue;
                    this.removeClassDefaults(obj, configObject.getObject(field.getName()));
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                map.entrySet().removeIf(entry -> !jsonObject.containsKey(entry.getKey()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

