/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.utils;

public interface ValueOperator {
    public int calc(int var1, int var2);

    public static class NUL
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return -1;
        }
    }

    public static class MOD
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return a % b;
        }
    }

    public static class POW
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            int result = 1;
            for (int i = 0; i < b; ++i) {
                result *= a;
            }
            return result;
        }
    }

    public static class DIV
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return a / b;
        }
    }

    public static class MUL
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return a * b;
        }
    }

    public static class SUB
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return a - b;
        }
    }

    public static class ADD
    implements ValueOperator {
        @Override
        public int calc(int a, int b) {
            return a + b;
        }
    }
}

