/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.bluebeaker.backpackdisplay.utils.fabric.FluidRenderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class FluidRender {
    public static void renderFluid(class_332 graphics, FluidStack fluidStack, int x, int y) {
        int color = FluidRender.getColorTint(fluidStack);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        FluidRender.setGLColorFromInt(color);
        class_1058 sprite = FluidRender.getStillFluidSprite(fluidStack);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        FluidRender.drawTexture(matrix, x, y, sprite, 100.0f);
        FluidRender.setGLColorFromInt(-1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1058 getStillFluidSprite(FluidStack fluidStack) {
        return FluidRenderImpl.getStillFluidSprite(fluidStack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getColorTint(FluidStack fluidStack) {
        return FluidRenderImpl.getColorTint(fluidStack);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTexture(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f, yCoord, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }
}

