/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.section.item;

import io.bluebeaker.backpackdisplay.BackpackDisplayMod;
import io.bluebeaker.backpackdisplay.ConfigProvider;
import io.bluebeaker.backpackdisplay.api.IDisplaySection;
import io.bluebeaker.backpackdisplay.crafttweaker.CTIntegration;
import io.bluebeaker.backpackdisplay.displayslot.IDisplaySlotEntry;
import io.bluebeaker.backpackdisplay.section.item.BPDRegistryItems;
import io.bluebeaker.backpackdisplay.utils.EnvironmentUtils;
import io.bluebeaker.backpackdisplay.utils.NumberUtils;
import io.bluebeaker.backpackdisplay.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class DisplaySectionItem
implements IDisplaySection {
    private class_1799 itemStack = class_1799.field_8037;
    private List<class_1799> itemsToRender = Collections.emptyList();
    private int overflowItems = 0;
    private int width = 0;
    private int height = 0;

    @Override
    public void update(class_1799 stack) {
        if (class_1799.method_31577((class_1799)stack, (class_1799)this.itemStack)) {
            return;
        }
        this.itemStack = stack.method_7972();
        this.itemsToRender = this.getItemsForItem(this.itemStack);
        this.updateGeometry();
    }

    private List<class_1799> getItemsForItem(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (EnvironmentUtils.isCraftTweakerLoaded()) {
            try {
                items.addAll(CTIntegration.getItemsForCT(stack));
            }
            catch (Exception e) {
                BackpackDisplayMod.logError("Exception when getting display items from crafttweaker: ", e);
            }
        }
        List<IDisplaySlotEntry> entries = DisplaySectionItem.getRenderRules(stack);
        for (IDisplaySlotEntry rule : entries) {
            items.addAll(rule.getItemsFromContainer(stack));
        }
        return items;
    }

    private void updateGeometry() {
        List<class_1799> items = this.itemsToRender;
        if (items.isEmpty()) {
            this.width = 0;
            this.height = 0;
            return;
        }
        int maxCount = ConfigProvider.getConfig().appearance.tooltipWidth * ConfigProvider.getConfig().appearance.tooltipHeight;
        int totalCount = items.size();
        int totalWidth = Math.min(items.size(), ConfigProvider.getConfig().appearance.tooltipWidth);
        this.overflowItems = totalCount > maxCount ? this.itemsToRender.size() - (maxCount - 1) : 0;
        int totalHeight = Math.min((totalCount - 1) / ConfigProvider.getConfig().appearance.tooltipWidth + 1, ConfigProvider.getConfig().appearance.tooltipHeight);
        int pixelWidth = totalWidth * 18;
        int pixelHeight = totalHeight * 18;
        this.width = pixelWidth;
        this.height = pixelHeight;
    }

    private static List<IDisplaySlotEntry> getRenderRules(class_1799 stack) {
        class_1792 item = stack.method_7909();
        List<IDisplaySlotEntry> entries = BPDRegistryItems.registry.get(item);
        return entries != null ? entries : Collections.emptyList();
    }

    @Override
    public void render(class_332 graphics, int x, int y) {
        int count = 0;
        List<class_1799> items = this.itemsToRender;
        int totalCount = this.itemsToRender.size() - this.overflowItems;
        if (this.overflowItems > 0) {
            RenderUtils.drawLabelCentered(graphics, x + (ConfigProvider.getConfig().appearance.tooltipWidth - 1) * 18, y + (ConfigProvider.getConfig().appearance.tooltipHeight - 1) * 18, "+" + NumberUtils.getItemCountRepresentation(this.overflowItems));
        }
        for (int i = 0; i < totalCount; ++i) {
            class_1799 stack2 = items.get(i);
            int slotX = count % ConfigProvider.getConfig().appearance.tooltipWidth;
            int slotY = count / ConfigProvider.getConfig().appearance.tooltipWidth;
            RenderUtils.renderItemStack(graphics, stack2, x + slotX * 18, y + slotY * 18);
            ++count;
        }
    }

    @Override
    public String getID() {
        return "items";
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isAvailable() {
        return !this.itemsToRender.isEmpty();
    }

    @Override
    public int defaultPriority() {
        return 0;
    }
}

