/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.section.fluid;

import dev.architectury.fluid.FluidStack;
import io.bluebeaker.backpackdisplay.BackpackDisplayMod;
import io.bluebeaker.backpackdisplay.ConfigProvider;
import io.bluebeaker.backpackdisplay.api.IDisplaySection;
import io.bluebeaker.backpackdisplay.crafttweaker.CTIntegration;
import io.bluebeaker.backpackdisplay.section.fluid.BPDRegistryFluid;
import io.bluebeaker.backpackdisplay.utils.EnvironmentUtils;
import io.bluebeaker.backpackdisplay.utils.FluidUtils;
import io.bluebeaker.backpackdisplay.utils.NumberUtils;
import io.bluebeaker.backpackdisplay.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class DisplaySectionFluid
implements IDisplaySection {
    private class_1799 itemStack = class_1799.field_8037;
    private List<FluidStack> fluidStacks = Collections.emptyList();
    private int overflowFluids = 0;
    private int width = 0;
    private int height = 0;

    @Override
    public int defaultPriority() {
        return -1;
    }

    @Override
    public String getID() {
        return "fluid";
    }

    @Override
    public void update(class_1799 stack) {
        if (class_1799.method_31577((class_1799)stack, (class_1799)this.itemStack)) {
            return;
        }
        this.itemStack = stack.method_7972();
        this.fluidStacks = this.getFluidStacks(stack);
        this.updateGeometry();
    }

    private List<FluidStack> getFluidStacks(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return Collections.emptyList();
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        fluids.addAll(this.getFluidStacksCT(stack));
        if (ConfigProvider.getConfig().fluidSection.simpleRule && this.isSimpleContainer(stack)) {
            List<FluidStack> fluidInItem = FluidUtils.getFluidInItem(stack);
            fluids.addAll(fluidInItem);
        }
        return fluids;
    }

    private List<FluidStack> getFluidStacksCT(class_1799 stack) {
        if (EnvironmentUtils.isCraftTweakerLoaded()) {
            try {
                return CTIntegration.getFluidsForCT(stack);
            }
            catch (Exception e) {
                BackpackDisplayMod.logError("Exception when getting display fluids from crafttweaker: ", e);
            }
        }
        return Collections.emptyList();
    }

    private boolean isSimpleContainer(class_1799 stack) {
        boolean invert = ConfigProvider.getConfig().fluidSection.simpleContainerListIsBlacklist;
        if (BPDRegistryFluid.registry.contains(stack.method_7909())) {
            return !invert;
        }
        return invert;
    }

    private void updateGeometry() {
        List<FluidStack> fluids = this.fluidStacks;
        if (fluids == null || fluids.isEmpty()) {
            this.width = 0;
            this.height = 0;
            return;
        }
        int maxCount = ConfigProvider.getConfig().appearance.tooltipWidth * ConfigProvider.getConfig().appearance.tooltipHeight;
        int totalCount = fluids.size();
        int totalWidth = Math.min(fluids.size(), ConfigProvider.getConfig().appearance.tooltipWidth);
        this.overflowFluids = totalCount > maxCount ? fluids.size() - (maxCount - 1) : 0;
        int totalHeight = Math.min((totalCount - 1) / ConfigProvider.getConfig().appearance.tooltipWidth + 1, ConfigProvider.getConfig().appearance.tooltipHeight);
        int pixelWidth = totalWidth * 18;
        int pixelHeight = totalHeight * 18;
        this.width = pixelWidth;
        this.height = pixelHeight;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isAvailable() {
        return !this.fluidStacks.isEmpty();
    }

    @Override
    public void render(class_332 graphics, int x, int y) {
        int count = 0;
        List<FluidStack> fluids = this.fluidStacks;
        int totalCount = fluids.size() - this.overflowFluids;
        if (this.overflowFluids > 0) {
            RenderUtils.drawLabelCentered(graphics, x + (ConfigProvider.getConfig().appearance.tooltipWidth - 1) * 18, y + (ConfigProvider.getConfig().appearance.tooltipHeight - 1) * 18, "+" + NumberUtils.getItemCountRepresentation(this.overflowFluids));
        }
        for (int i = 0; i < totalCount; ++i) {
            FluidStack stack2 = fluids.get(i);
            int slotX = count % ConfigProvider.getConfig().appearance.tooltipWidth;
            int slotY = count / ConfigProvider.getConfig().appearance.tooltipWidth;
            RenderUtils.renderFluidStack(graphics, stack2, x + slotX * 18, y + slotY * 18);
            ++count;
        }
    }
}

