/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.displayslot;

import io.bluebeaker.backpackdisplay.utils.NBTUtils;
import io.bluebeaker.backpackdisplay.utils.ValueOperator;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;

public class ValueOperation {
    public final ValueOperator operator;
    public final String[] pathToValue;

    public ValueOperation(String path) {
        this.pathToValue = NBTUtils.getKeysList(path.substring(1));
        switch (path.charAt(0)) {
            case '+': {
                this.operator = new ValueOperator.ADD();
                break;
            }
            case '-': {
                this.operator = new ValueOperator.SUB();
                break;
            }
            case '*': {
                this.operator = new ValueOperator.MUL();
                break;
            }
            case '/': {
                this.operator = new ValueOperator.DIV();
                break;
            }
            case '^': {
                this.operator = new ValueOperator.POW();
                break;
            }
            case '%': {
                this.operator = new ValueOperator.MOD();
                break;
            }
            default: {
                this.operator = new ValueOperator.NUL();
            }
        }
    }

    public int doOperation(int num, class_2487 tag) {
        class_2520 tagNum = NBTUtils.getTagRecursive((class_2520)tag, this.pathToValue);
        if (NBTUtils.isNumber(tagNum)) {
            return this.operator.calc(num, ((class_2514)tagNum).method_10701());
        }
        return -1;
    }
}

