/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import io.bluebeaker.backpackdisplay.crafttweaker.IContainerFunctionFluid;
import io.bluebeaker.backpackdisplay.utils.IngredientMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.backpackdisplay.BackpackDisplayFluid")
@ZenRegister
public class BackpackDisplayFluidCT {
    private static final IngredientMap<IContainerFunctionFluid> PREVIEW_FUNCTIONS = new IngredientMap();

    @ZenCodeType.Method
    public static void addBackDisplay(IIngredient ingredient, IContainerFunctionFluid function) {
        CraftTweakerAPI.apply((IAction)new AddBackpackDisplayAction(ingredient, function));
    }

    public static List<IContainerFunctionFluid> getFunctions(IItemStack item) {
        return PREVIEW_FUNCTIONS.getEntries(item);
    }

    public static List<IFluidStack> getDisplayFluids(IItemStack item) {
        ArrayList<IFluidStack> items = new ArrayList<IFluidStack>();
        for (IContainerFunctionFluid func : BackpackDisplayFluidCT.getFunctions(item)) {
            items.addAll(Arrays.asList(func.process(item)));
        }
        return items;
    }

    public static class AddBackpackDisplayAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final IContainerFunctionFluid function;
        @Nullable
        private IngredientMap.IngredientMapEntry<IContainerFunctionFluid> entry;

        public AddBackpackDisplayAction(IIngredient ingredient, IContainerFunctionFluid function) {
            this.ingredient = ingredient;
            this.function = function;
        }

        public void apply() {
            this.entry = PREVIEW_FUNCTIONS.register(this.ingredient, this.function);
        }

        public void undo() {
            PREVIEW_FUNCTIONS.unregister(this.entry);
        }

        public String describe() {
            return "Adding backpack display fluid for " + String.valueOf(this.ingredient);
        }

        public String describeUndo() {
            return "Removing backpack display fluid for " + String.valueOf(this.ingredient);
        }

        public String systemName() {
            return "backpackdisplay-Fluid";
        }
    }
}

