/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay;

import io.bluebeaker.backpackdisplay.BackpackDisplayMod;
import io.bluebeaker.backpackdisplay.ConfigProvider;
import io.bluebeaker.backpackdisplay.api.IDisplaySection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SectionsManager {
    private static final List<IDisplaySection> sections = new ArrayList<IDisplaySection>();
    protected static HashMap<String, Integer> sectionPriorities = new HashMap();
    protected static SectionSorter sectionSorter = new SectionSorter();

    public static void addSection(IDisplaySection newSection) {
        sections.add(newSection);
    }

    public static List<IDisplaySection> getSections() {
        return sections;
    }

    public static void sortSections() {
        sections.sort(sectionSorter);
    }

    public static int getPriority(IDisplaySection section) {
        String id = section.getID();
        if (sectionPriorities.containsKey(id)) {
            return sectionPriorities.get(id);
        }
        return section.defaultPriority();
    }

    public static void updateFromConfig() {
        for (String rule : ConfigProvider.getConfig().priorities) {
            String[] split = rule.replaceAll(" ", "").split(":");
            if (split.length >= 2) {
                String id = split[0];
                try {
                    int priority = Integer.parseInt(split[1]);
                    sectionPriorities.put(id, priority);
                }
                catch (Exception e) {
                    BackpackDisplayMod.logError("Error when loading priority, please check it.", e);
                }
                continue;
            }
            BackpackDisplayMod.logError("Priority rule format error: must be 'id:priority'");
        }
    }

    public static void updateToConfig() {
        ArrayList<String> priorities = new ArrayList<String>(Arrays.asList(ConfigProvider.getConfig().priorities));
        boolean modified = false;
        for (IDisplaySection section : sections) {
            String id = section.getID();
            if (sectionPriorities.containsKey(id)) continue;
            priorities.add(id + ":" + section.defaultPriority());
            modified = true;
        }
        if (modified) {
            ConfigProvider.getConfig().priorities = priorities.toArray(new String[0]);
        }
    }

    protected static class SectionSorter
    implements Comparator<IDisplaySection> {
        protected SectionSorter() {
        }

        @Override
        public int compare(IDisplaySection o1, IDisplaySection o2) {
            int result = SectionsManager.getPriority(o2) - SectionsManager.getPriority(o1);
            if (result > 1) {
                result = 1;
            } else if (result < -1) {
                result = -1;
            }
            return result;
        }
    }
}

