/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay;

import io.bluebeaker.backpackdisplay.BPDConfig;
import io.bluebeaker.backpackdisplay.BPDConfigHelper;
import io.bluebeaker.backpackdisplay.ConfigProvider;
import io.bluebeaker.backpackdisplay.Keybind;
import io.bluebeaker.backpackdisplay.SectionsManager;
import io.bluebeaker.backpackdisplay.api.IDisplaySection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BPDTooltip {
    private static int screenWidth;
    private static int mouseX;
    private static class_1799 lastStack;
    private static class_310 client;

    public static boolean beforeRender() {
        return ConfigProvider.getConfig().keybindRequirement == BPDConfig.KeybindType.NOT_NEEDED || !(ConfigProvider.getConfig().keybindRequirement == BPDConfig.KeybindType.PRESSED ^ Keybind.keyShowContents.method_1434());
    }

    public static void render(class_1799 stack, class_332 guiGraphics, int x, int y, int w, int h) {
        BPDTooltip.updateSections(stack);
        BPDTooltip.renderTooltip(stack, guiGraphics, x, y, w, h);
    }

    public static void updateSections(class_1799 stack) {
        if (stack == null || class_1799.method_31577((class_1799)stack, (class_1799)lastStack)) {
            return;
        }
        List<IDisplaySection> sections = SectionsManager.getSections();
        for (IDisplaySection section : sections) {
            section.update(stack);
        }
        lastStack = stack.method_7972();
    }

    private static void renderTooltip(class_1799 stack, class_332 guiGraphics, int x, int y, int w, int h) {
        List<IDisplaySection> sections = SectionsManager.getSections();
        int height = 0;
        int width = 0;
        int availaleSections = 0;
        for (IDisplaySection section : sections) {
            if (!section.isAvailable()) continue;
            ++availaleSections;
            height += section.getHeight();
            width = Math.max(section.getWidth(), width);
        }
        if (availaleSections == 0) {
            return;
        }
        int drawX = x + ConfigProvider.getConfig().appearance.offset_x;
        int drawY = y + ConfigProvider.getConfig().appearance.offset_y - height;
        if (drawY < 4) {
            drawY = y + h + 8;
        }
        if (drawX + width + 4 > screenWidth) {
            drawX = screenWidth - width - 4;
        } else if (x + width < mouseX) {
            drawX = x + w - width;
        }
        guiGraphics.method_51448().method_22903();
        int backgroundColor = BPDConfigHelper.backgroundColor;
        int borderColorStart = BPDConfigHelper.borderColorStart;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        BPDTooltip.drawBackground(guiGraphics, drawX, drawY, width, height, backgroundColor, borderColorStart, borderColorEnd);
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 399.0f);
        for (IDisplaySection section : sections) {
            if (!section.isAvailable()) continue;
            section.render(guiGraphics, drawX, drawY);
            drawY += section.getHeight();
        }
        guiGraphics.method_51448().method_22909();
    }

    public static void drawBackground(class_332 guiGraphics, int x, int y, int width, int height, int bgColor, int borderColorStart, int borderColorEnd) {
        int bgX = x - 3;
        int bgY = y - 3;
        int bgW = width + 6;
        int bgH = height + 6;
        int z = 400;
        guiGraphics.method_51737(bgX, bgY - 1, bgX + bgW, bgY, z, bgColor);
        guiGraphics.method_51737(bgX, bgY + bgH, bgX + bgW, bgY + bgH + 1, z, bgColor);
        guiGraphics.method_51737(bgX, bgY, bgX + bgW, bgY + bgH, z, bgColor);
        guiGraphics.method_51737(bgX - 1, bgY, bgX, bgY + bgH, z, bgColor);
        guiGraphics.method_51737(bgX + bgW, bgY, bgX + bgW + 1, bgY + bgH, z, bgColor);
        guiGraphics.method_33284(bgX, bgY + 1, bgX + 1, bgY + 1 + bgH - 2, z, borderColorStart, borderColorEnd);
        guiGraphics.method_33284(bgX + bgW - 1, bgY + 1, bgX + bgW, bgY + 1 + bgH - 2, z, borderColorStart, borderColorEnd);
        guiGraphics.method_51737(bgX, bgY, bgX + bgW, bgY + 1, z, borderColorStart);
        guiGraphics.method_51737(bgX, bgY + bgH - 1, bgX + bgW, bgY + bgH, z, borderColorEnd);
    }

    public static void updateParams(int screenWidth, int mouseX) {
        BPDTooltip.screenWidth = screenWidth;
        BPDTooltip.mouseX = mouseX;
    }

    static {
        lastStack = class_1799.field_8037;
        client = class_310.method_1551();
    }
}

