/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import immersive_armors.Main;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.client.render.entity.piece.Piece;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_3414;

public class ExtendedArmorMaterial
implements class_1741 {
    private final String name;
    private int durabilityMultiplier;
    private int[] protectionAmount;
    private final boolean[] hidesSecondLayer = new boolean[]{false, false, false, false};
    private float toughness;
    private float knockbackResistance;
    private int enchantability;
    private float weight;
    private int extraHealth;
    private int color = 10511680;
    private float attackDamage;
    private float attackSpeed;
    private int luck;
    private final List<ArmorEffect> effects = new LinkedList<ArmorEffect>();
    private final Map<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>();
    private final Map<String, Float> loot = new HashMap<String, Float>();
    private boolean antiSkeleton;
    private final Map<class_1304, List<Piece>> pieces = new HashMap<class_1304, List<Piece>>();
    private boolean hideCape;
    private class_3414 equipSound;
    private Supplier<class_1856> repairIngredient;
    private static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};

    public ExtendedArmorMaterial(String name) {
        this.pieces.put(class_1304.field_6169, new LinkedList());
        this.pieces.put(class_1304.field_6174, new LinkedList());
        this.pieces.put(class_1304.field_6172, new LinkedList());
        this.pieces.put(class_1304.field_6166, new LinkedList());
        this.name = name;
        this.protectionAmount(0, 0, 0, 0);
    }

    public ExtendedArmorMaterial durabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ExtendedArmorMaterial protectionAmount(int helmet, int chestplate, int legging, int boots) {
        this.protectionAmount = new int[]{boots, legging, chestplate, helmet};
        return this;
    }

    public ExtendedArmorMaterial toughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ExtendedArmorMaterial enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ExtendedArmorMaterial equipSound(class_3414 equipSound) {
        this.equipSound = equipSound;
        return this;
    }

    public ExtendedArmorMaterial repairIngredient(Supplier<class_1856> repairIngredient) {
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ExtendedArmorMaterial knockbackReduction(float knockbackReduction) {
        this.knockbackResistance = knockbackReduction;
        return this;
    }

    public ExtendedArmorMaterial weight(float weight) {
        this.weight = weight;
        return this;
    }

    public ExtendedArmorMaterial extraHealth(int extraHealth) {
        this.extraHealth = extraHealth;
        return this;
    }

    public ExtendedArmorMaterial color(int color) {
        this.color = color;
        return this;
    }

    public ExtendedArmorMaterial attackDamage(int attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    public ExtendedArmorMaterial attackSpeed(int attackSpeed) {
        this.attackSpeed = attackSpeed;
        return this;
    }

    public ExtendedArmorMaterial luck(int luck) {
        this.luck = luck;
        return this;
    }

    public ExtendedArmorMaterial effect(ArmorEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ExtendedArmorMaterial enchantment(class_1887 enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ExtendedArmorMaterial antiSkeleton() {
        this.antiSkeleton = true;
        return this;
    }

    public ExtendedArmorMaterial hideCape() {
        this.hideCape = true;
        return this;
    }

    public ExtendedArmorMaterial head(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6169).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial chest(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6174).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial legs(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6172).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial feet(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6166).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial upper(Piece pieceSupplier) {
        this.head(pieceSupplier);
        this.chest(pieceSupplier);
        this.feet(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial lower(Piece pieceSupplier) {
        this.legs(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial full(Piece pieceSupplier) {
        this.upper(pieceSupplier);
        this.lower(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial addLoot(String name, float chance) {
        this.loot.put(name, Float.valueOf(chance));
        return this;
    }

    public String method_7694() {
        return this.name;
    }

    public int method_48402(class_1738.class_8051 slot) {
        return BASE_DURABILITY[slot.method_48399().method_5927()] * this.durabilityMultiplier;
    }

    public int method_48403(class_1738.class_8051 slot) {
        return this.protectionAmount[slot.method_48399().method_5927()];
    }

    public float method_7700() {
        return this.toughness;
    }

    public int method_7699() {
        return this.enchantability;
    }

    public class_3414 method_7698() {
        return this.equipSound;
    }

    public class_1856 method_7695() {
        return this.repairIngredient.get();
    }

    public float method_24355() {
        return this.knockbackResistance;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getExtraHealth() {
        return this.extraHealth;
    }

    public int getColor() {
        return this.color;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public int getLuck() {
        return this.luck;
    }

    public List<ArmorEffect> getEffects() {
        if (Main.sharedConfig.enableEffects) {
            return this.effects;
        }
        return Collections.emptyList();
    }

    public Map<class_1887, Integer> getEnchantments() {
        return this.enchantments;
    }

    public boolean hasEnchantment(class_1887 enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int getEnchantment(class_1887 enchantment) {
        return this.enchantments.get(enchantment);
    }

    public boolean shouldHideCape() {
        return this.hideCape;
    }

    public List<Piece> getPieces(class_1304 slot) {
        return this.pieces.get(slot);
    }

    public ExtendedArmorMaterial hidesSecondLayer(boolean head, boolean chest, boolean legs, boolean feet) {
        this.hidesSecondLayer[0] = head;
        this.hidesSecondLayer[1] = chest;
        this.hidesSecondLayer[2] = legs;
        this.hidesSecondLayer[3] = feet;
        return this;
    }

    public boolean[] shouldHideSecondLayer() {
        return this.hidesSecondLayer;
    }

    public boolean isAntiSkeleton() {
        return this.antiSkeleton;
    }

    public int[] getProtectionAmounts() {
        return this.protectionAmount;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public Map<String, Float> getLoot() {
        return this.loot;
    }
}

