/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4719;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureSlots;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeskBlock
extends class_2248
implements class_3737 {
    private static final String TEXTURE_PATH = "block/desk/";
    public static final Map<String, List<class_4945>> VARIANT_TEXTURES = ImmutableMap.builder().put((Object)"single", (Object)ImmutableList.of((Object)ModTextureSlots.TOP, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE)).put((Object)"center", (Object)ImmutableList.of((Object)ModTextureSlots.TOP_SIDE, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE, (Object)ModTextureSlots.MIDDLE)).put((Object)"left_or_right", (Object)ImmutableList.of((Object)ModTextureSlots.TOP, (Object)ModTextureSlots.TOP_SIDE, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE, (Object)ModTextureSlots.MIDDLE)).build();
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 LEFT = ModBlockStateProperties.LEFT;
    public static final class_2746 RIGHT = ModBlockStateProperties.RIGHT;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Map<class_2680, class_265> shapesCache;
    private static final class_265 TOP_SHAPE = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_265> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    protected static final class_265 SHAPE = class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), class_2248.method_9541((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private static final Map<class_2350, class_265> CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<class_2350, class_265> FULL_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_2248.method_9541((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private static final Map<class_2350, class_265> LEFT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_2248.method_9541((double)0.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<class_2350, class_265> RIGHT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private final class_4719 woodType;
    private final class_6862<class_2248> tag;

    public DeskBlock(class_4719 woodType, class_6862<class_2248> tag, class_4970.class_2251 properties) {
        super(properties);
        this.woodType = woodType;
        this.tag = tag;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.method_33615(this::calculateShape);
    }

    private class_265 calculateShape(class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        boolean left = (Boolean)state.method_11654((class_2769)LEFT);
        boolean right = (Boolean)state.method_11654((class_2769)RIGHT);
        if (left && right) {
            return class_259.method_1084((class_265)TOP_SHAPE, (class_265)FULL_CONNECT_SHAPES.get(facing.method_10153()));
        }
        if (left) {
            return class_259.method_17786((class_265)TWO_LEGS_SHAPES.get(facing.method_10170()), (class_265[])new class_265[]{LEFT_CONNECT_SHAPES.get(facing.method_10153()), CONNECT_SHAPES.get(facing.method_10170().method_10153())});
        }
        if (right) {
            return class_259.method_17786((class_265)TWO_LEGS_SHAPES.get(facing.method_10170().method_10153()), (class_265[])new class_265[]{RIGHT_CONNECT_SHAPES.get(facing.method_10153()), CONNECT_SHAPES.get(facing.method_10170())});
        }
        return class_259.method_17786((class_265)SHAPE, (class_265[])new class_265[]{CONNECT_SHAPES.get(facing.method_10153()), CONNECT_SHAPES.get(facing.method_10170().method_10153()), CONNECT_SHAPES.get(facing.method_10170())});
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.shapesCache.get(state);
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        boolean right;
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 facing = context.method_8042().method_10153();
        boolean flag = level.method_8316(pos).method_15772() == class_3612.field_15910;
        class_2680 leftState = level.method_8320(pos.method_10093(facing.method_10170()));
        class_2680 secondLefState = level.method_8320(pos.method_10079(facing.method_10170(), 2));
        class_2680 rightState = level.method_8320(pos.method_10093(facing.method_10160()));
        class_2680 secondRightState = level.method_8320(pos.method_10079(facing.method_10160(), 2));
        boolean left = this.hasSameFacing(leftState, facing) && (!secondLefState.method_26164(this.tag) || secondLefState.method_11654((class_2769)FACING) != facing || !this.isCenterPart(secondLefState));
        boolean bl = right = this.hasSameFacing(rightState, facing) && (!secondRightState.method_26164(this.tag) || secondRightState.method_11654((class_2769)FACING) != facing || !this.isCenterPart(secondRightState));
        if (left && right) {
            if (this.hasSameFacing(secondRightState, facing) && ((Boolean)secondRightState.method_11654((class_2769)LEFT)).booleanValue()) {
                right = false;
            } else if (this.hasSameFacing(secondLefState, facing) && ((Boolean)secondLefState.method_11654((class_2769)RIGHT)).booleanValue()) {
                left = false;
            }
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(left))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(right))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean isCenterPart(class_2680 state) {
        return state.method_26164(this.tag) && (Boolean)state.method_11654((class_2769)LEFT) != false && (Boolean)state.method_11654((class_2769)RIGHT) != false;
    }

    public boolean hasSameFacing(class_2680 state, class_2350 facing) {
        return state.method_26164(this.tag) && state.method_11654((class_2769)FACING) == facing;
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 currentPos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        boolean flag = this.hasSameFacing(neighborState, facing);
        if (direction == facing.method_10170()) {
            return (class_2680)state.method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.method_11654((class_2769)RIGHT) != false));
        }
        if (direction == facing.method_10160()) {
            return (class_2680)state.method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.method_11654((class_2769)LEFT) != false));
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, LEFT, RIGHT, WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9526(@NotNull class_2680 state) {
        return true;
    }
}

