/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCurtainBlock<T extends CurtainPart>
extends class_2248 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final class_265 BRACKET_SHAPE = class_2248.method_9541((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Map<class_2350, class_265> TOP_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_1084((class_265)SHAPE, (class_265)BRACKET_SHAPE));
    public static final Map<class_2350, class_265> SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)SHAPE);
    public static final Map<class_2350, class_265> BRACKET_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)BRACKET_SHAPE);
    private final class_1767 color;

    public AbstractCurtainBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.color = color;
    }

    @NotNull
    public class_265 method_25959(@NotNull class_2680 state, @NotNull class_1922 blockGetter, @NotNull class_2338 pos) {
        return class_259.method_1073();
    }

    public class_1767 getColor() {
        return this.color;
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_21466;
        }
        this.updateOpen(state, level, pos);
        return class_1269.field_5812;
    }

    protected abstract void updateOpen(class_2680 var1, class_1937 var2, class_2338 var3);

    protected abstract T getPart(class_2680 var1);

    public void method_9612(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2248 block, @NotNull class_2338 fromPos, boolean isMoving) {
        boolean powered = level.method_49803(pos);
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue() != level.method_49803(pos)) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)));
            if (powered) {
                this.updateOpen(state, level, pos);
            }
        }
    }

    protected class_2338 getTopBlock(class_1936 level, class_2338 currentPos) {
        class_2338.class_2339 pos = currentPos.method_25503();
        class_2680 state = level.method_8320(pos.method_10084());
        while (state.method_27852((class_2248)this) && !this.getPart(state).isBottomOrSingle()) {
            pos.method_10098(class_2350.field_11036);
            state = level.method_8320(pos.method_10084());
        }
        return pos.method_10062();
    }

    protected void openRows(class_1937 level, class_2680 state, class_2338.class_2339 topPos, class_2350 direction, class_2350 baseDirection, int length) {
        boolean leftDirection = baseDirection.method_10170() == direction;
        while (true) {
            topPos.method_10098(direction);
            if (!this.isConnected((class_1936)level, state, (class_2338)topPos, length)) break;
            boolean leftConnected = !leftDirection || this.isConnected((class_1936)level, state, (class_2338)topPos, baseDirection.method_10170(), length);
            boolean rightConnected = leftDirection || this.isConnected((class_1936)level, state, (class_2338)topPos, baseDirection.method_10160(), length);
            this.openRow(level, (class_2338)topPos, length, leftConnected, rightConnected);
        }
    }

    protected abstract void openRow(class_1937 var1, class_2338 var2, int var3, boolean var4, boolean var5);

    protected boolean isConnected(class_1936 level, class_2680 state, class_2338 pos, class_2350 direction, int length) {
        return this.isConnected(level, state, pos.method_10093(direction), length);
    }

    private boolean isConnected(class_1936 level, class_2680 state, class_2338 neighborPos, int length) {
        class_2680 neighborState = level.method_8320(neighborPos);
        if (!this.shouldUpdateTogether(level, state, neighborPos, length)) {
            return false;
        }
        T part = this.getPart(neighborState);
        return part.isTopOrSingle() || this.bothSingle(state, neighborState) || part == OpenCurtainPart.LEFT || part == OpenCurtainPart.RIGHT;
    }

    private boolean shouldUpdateTogether(class_1936 level, class_2680 state, class_2338 neighborPos, int length) {
        class_2680 neighborState = level.method_8320(neighborPos);
        if (!this.belongTogether(state, neighborState)) {
            return false;
        }
        if (this.isOpen() && (this.getPart(state).isSingleRow() || this.getPart(neighborState).isSingleRow())) {
            return false;
        }
        return this.getCurtainLength(level, neighborPos) == length;
    }

    protected abstract boolean isOpen();

    private boolean belongTogether(class_2680 state, class_2680 neighborState) {
        return neighborState.method_27852((class_2248)this) && this.hasSameFacing(state, neighborState);
    }

    private boolean bothSingle(class_2680 state, class_2680 neighborState) {
        return this.getPart(state).isSingle() && this.getPart(neighborState).isSingle();
    }

    private boolean hasSameFacing(class_2680 state, class_2680 neighborState) {
        return state.method_11654((class_2769)FACING) == neighborState.method_11654((class_2769)FACING);
    }

    protected int getCurtainLength(class_1936 level, class_2338 topPos) {
        class_2338.class_2339 pos = topPos.method_25503().method_10098(class_2350.field_11033);
        class_2680 state = level.method_8320((class_2338)pos);
        int length = 1;
        while (state.method_27852((class_2248)this) && !this.getPart(state).isTopOrSingle()) {
            state = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033));
            ++length;
        }
        return length;
    }

    protected abstract T connect(class_2680 var1, class_2680 var2, class_2350 var3);

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

