/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.mixins.WalkAnimationStateAccessor;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5131;
import net.minecraft.class_6025;

public class PetInfo {
    private class_1309 petEntity;
    private boolean inAltar;
    private boolean inItem;
    private boolean isAlive;
    private boolean wasRevived;
    private String ownerName;
    private class_5131 attributeMap;
    private boolean updated;

    public PetInfo(class_1309 entity) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        this.wasRevived = false;
        this.trySetOwner();
        this.attributeMap = entity.method_6127();
        this.setupPose();
    }

    public PetInfo(class_1309 entity, String ownerName) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        this.wasRevived = false;
        this.ownerName = ownerName;
        this.attributeMap = entity.method_6127();
        this.setupPose();
    }

    public PetInfo() {
    }

    public void setInItem(boolean flag) {
        this.inItem = flag;
    }

    public boolean isInItem() {
        return this.inItem;
    }

    public class_1309 getPetEntity() {
        return this.petEntity;
    }

    public class_2561 getName() {
        if (this.petEntity == null) {
            return class_2561.method_43473();
        }
        return this.petEntity.method_5476();
    }

    public class_2499 getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.method_26855();
        }
        return new class_2499();
    }

    public class_1309 getRender() {
        return this.petEntity;
    }

    public String getOwner() {
        if (this.ownerName == null || this.ownerName.isEmpty()) {
            this.trySetOwner();
        }
        return this.ownerName;
    }

    private void trySetOwner() {
        if (this.petEntity == null) {
            this.ownerName = "";
            return;
        }
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = DomesticationHelper.getOwnerName(this.petEntity);
            }
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = DawnEraHelper.getOwnerName(this.petEntity);
            }
            if (PickablePets.FoundGoety && GoetyHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = GoetyHelper.getOwnerName(this.petEntity);
            }
        }
        if (!isException) {
            class_2561 name;
            class_1309 ownerEntity = ((class_6025)this.petEntity).method_35057();
            this.ownerName = ownerEntity != null ? ((name = ownerEntity.method_5476()) != null ? name.getString() : "") : "";
        }
    }

    public void updateEntity(class_1309 newEntity) {
        this.petEntity = newEntity;
    }

    public void updateAttributes(class_1309 entity) {
        this.attributeMap = entity.method_6127();
    }

    public void markDead() {
        this.isAlive = false;
    }

    public void revive() {
        this.petEntity.field_6017 = 0.0f;
        this.petEntity.method_6125(0.0f);
        this.isAlive = true;
        this.wasRevived = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        this.updated = true;
    }

    public boolean wasRevived() {
        return this.wasRevived;
    }

    public class_2487 save(class_2487 tag) {
        if (this.petEntity != null) {
            tag = this.petEntity.method_5647(tag);
            tag.method_10582("pp_type", class_1299.method_5890((class_1299)this.petEntity.method_5864()).toString());
            tag.method_10556("pp_altar", this.inAltar);
            tag.method_10556("pp_item", this.inItem);
            tag.method_10556("pp_alive", this.isAlive);
            tag.method_10556("pp_revived", this.wasRevived);
            tag.method_10582("pp_owner", this.ownerName);
            if (this.attributeMap != null) {
                tag.method_10566("pp_attributes", (class_2520)this.attributeMap.method_26855());
            }
            tag.method_10556("pp_updated", this.updated);
        }
        return tag;
    }

    public void load(UUID petId, class_2487 tag, class_1937 level) {
        if (!tag.method_10545("pp_type")) {
            return;
        }
        Optional entityType = class_1299.method_5898((String)tag.method_10558("pp_type"));
        if (entityType.isEmpty()) {
            return;
        }
        this.petEntity = (class_1309)((class_1299)entityType.get()).method_5883(level);
        if (this.petEntity == null) {
            return;
        }
        this.petEntity.method_5651(tag);
        this.petEntity.method_5826(petId);
        this.inAltar = tag.method_10545("pp_altar") && tag.method_10577("pp_altar");
        this.inItem = tag.method_10545("pp_item") && tag.method_10577("pp_item");
        this.isAlive = tag.method_10545("pp_alive") && tag.method_10577("pp_alive");
        this.wasRevived = tag.method_10545("pp_revived") && tag.method_10577("pp_revived");
        String string = this.ownerName = tag.method_10545("pp_owner") ? tag.method_10558("pp_owner") : "";
        if (tag.method_10545("pp_attributes")) {
            this.attributeMap = this.petEntity.method_6127();
            this.attributeMap.method_26850(tag.method_10554("pp_attributes", 10));
        }
        if (tag.method_10545("pp_updated")) {
            this.updated = tag.method_10577("pp_updated");
        }
        this.setupPose();
        level.method_16107().method_15407();
    }

    private void setupPose() {
        if (this.petEntity == null) {
            return;
        }
        this.petEntity.field_6283 = 0.0f;
        this.petEntity.field_6220 = 0.0f;
        this.petEntity.field_5982 = 0.0f;
        this.petEntity.field_6004 = 0.0f;
        this.petEntity.method_36456(0.0f);
        this.petEntity.method_36457(0.0f);
        this.petEntity.field_6241 = 0.0f;
        this.petEntity.field_6259 = 0.0f;
        this.petEntity.field_6213 = 0;
        ((WalkAnimationStateAccessor)this.petEntity.field_42108).setSpeedOld(0.0f);
        this.petEntity.method_6125(0.0f);
        ((WalkAnimationStateAccessor)this.petEntity.field_42108).setPosition(0.0f);
        this.petEntity.field_6014 = 0.0;
        this.petEntity.field_5969 = 0.0;
        this.petEntity.field_6251 = 0.0f;
        this.petEntity.method_37908().method_16107().method_15407();
    }
}

