/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.client.gui.ReviveAltarScreen;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5218;

public class AltarPacket {
    private static final class_2960 PACKET_ID = new class_2960("pickablepets", "altar");

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)PACKET_ID, Server::receive);
        }

        public static void sendToPlayer(class_3222 player, List<String> petsIDS) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.writeInt(petsIDS.size());
            petsIDS.forEach(arg_0 -> ((class_2540)buffer).method_10814(arg_0));
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)PACKET_ID, (class_2540)buffer);
        }

        public static void receive(class_2540 buffer, NetworkManager.PacketContext context) {
            if (context.getPlayer().method_7340()) {
                return;
            }
            UUID playerID = buffer.method_10790();
            Path path = context.getPlayer().method_5682().method_27050(new class_5218("data/pets"));
            path = path.resolve(playerID.toString() + ".pets");
            ArrayList<String> broken = new ArrayList<String>();
            PlayerPets.loadPetAsync(path).thenCompose(list -> {
                ArrayList<String> fixed = new ArrayList<String>();
                list.forEach(uuid -> {
                    if (CachedPets.isValidPet(uuid)) {
                        fixed.add((String)uuid);
                    } else {
                        broken.add((String)uuid);
                    }
                });
                Server.sendToPlayer((class_3222)context.getPlayer(), fixed);
                return null;
            });
            PlayerPets.removeBrokenPetsAsync(path, broken);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)PACKET_ID, Client::receive);
        }

        public static void sendToServer() {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10797(class_310.method_1551().field_1724.method_5667());
            NetworkManager.sendToServer((class_2960)PACKET_ID, (class_2540)buffer);
        }

        public static void receive(class_2540 buffer, NetworkManager.PacketContext context) {
            if (!context.getPlayer().method_7340()) {
                return;
            }
            class_310 mc = class_310.method_1551();
            class_437 class_4372 = mc.field_1755;
            if (!(class_4372 instanceof ReviveAltarScreen)) {
                return;
            }
            ReviveAltarScreen altarScreen = (ReviveAltarScreen)class_4372;
            ArrayList<UUID> pets = new ArrayList<UUID>();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                UUID uuid = UUID.fromString(buffer.method_19772());
                CachedPets.getRender(uuid);
                pets.add(uuid);
            }
            altarScreen.populatePetList(pets);
        }
    }
}

