/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSlabBlock
extends class_2482
implements BlockModelProvider,
CustomItemProvider,
TagProvider,
DropSelfLootProvider<BaseSlabBlock> {
    private final class_2248 parent;
    public final boolean fireproof;

    protected BaseSlabBlock(class_2248 source, boolean fireproof) {
        super(class_4970.class_2251.method_9630((class_4970)source));
        this.parent = source;
        this.fireproof = fireproof;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 resourceLocation) {
        return this.getBlockModel(resourceLocation, this.method_9564());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        class_2960 parentId = class_7923.field_41175.method_10221((Object)this.parent);
        Optional<String> pattern = blockState.method_11654((class_2769)field_11501) == class_2771.field_12682 ? PatternsHelper.createBlockSimple(parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_SLAB, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2771 type = (class_2771)blockState.method_11654((class_2769)field_11501);
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + "_" + type);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        if (type == class_2771.field_12679) {
            return ModelsHelper.createMultiVariant(modelId, class_1086.field_5358.method_3509(), true);
        }
        return ModelsHelper.createBlockSimple(modelId);
    }

    @Override
    public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
        blockTags.add((class_6862<class_2248>)class_3481.field_15469);
        itemTags.add((class_6862<class_1792>)class_3489.field_15535);
    }

    @Override
    public class_1747 getCustomItem(class_2960 blockID, class_1792.class_1793 settings) {
        if (this.fireproof) {
            settings = settings.method_24359();
        }
        return new class_1747((class_2248)this, settings);
    }

    public static BaseSlabBlock from(class_2248 source, boolean flammable) {
        return BehaviourHelper.from(source, s -> new Wood((class_2248)s, !flammable), s -> new Stone((class_2248)s, !flammable), s -> new Metal((class_2248)s, !flammable), s -> new Obsidian((class_2248)s, !flammable), null);
    }

    public static class Obsidian
    extends BaseSlabBlock
    implements BehaviourObsidian {
        public Obsidian(class_2248 source) {
            super(source, true);
        }

        public Obsidian(class_2248 source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Metal
    extends BaseSlabBlock
    implements BehaviourMetal {
        public Metal(class_2248 source) {
            this(source, true);
        }

        public Metal(class_2248 source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Stone
    extends BaseSlabBlock
    implements BehaviourStone {
        public Stone(class_2248 source) {
            this(source, true);
        }

        public Stone(class_2248 source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Wood
    extends BaseSlabBlock
    implements BehaviourWood {
        public Wood(class_2248 source) {
            this(source, false);
        }

        public Wood(class_2248 source, boolean fireproof) {
            super(source, fireproof);
        }

        @Override
        public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((class_6862<class_2248>)class_3481.field_15468);
            itemTags.add((class_6862<class_1792>)class_3489.field_15534);
        }
    }
}

