/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5168;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.ComposterAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimable;
import org.betterx.bclib.behaviours.interfaces.BehaviourCompostable;
import org.betterx.bclib.behaviours.interfaces.BehaviourImmobile;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourOre;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourPortalFrame;
import org.betterx.bclib.behaviours.interfaces.BehaviourSaplingLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeedLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourShearablePlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantLike;
import org.betterx.bclib.behaviours.interfaces.BlockBehaviour;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.client.render.BaseChestBlockEntityRenderer;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.Fuel;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.interfaces.tools.HasMinableBehaviour;
import org.betterx.bclib.interfaces.tools.PreventMineableAdd;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BasePickaxeItem;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.networking.VersionChecker;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.tag.v3.ToolTags;

public class PostInitAPI {
    private static List<Consumer<Boolean>> postInitFunctions = Lists.newArrayList();
    private static List<class_6862<class_2248>> blockTags = Lists.newArrayList();
    private static List<class_6862<class_1792>> itemTags = Lists.newArrayList();

    public static void register(Consumer<Boolean> function) {
        postInitFunctions.add(function);
    }

    public static void postInit(boolean isClient) {
        class_7923.field_41175.forEach(block -> {
            PostInitAPI.processBlockCommon(block);
            if (isClient) {
                PostInitAPI.processBlockClient(block);
            }
        });
        class_7923.field_41178.forEach(item -> PostInitAPI.processItemCommon(item));
        if (postInitFunctions != null) {
            postInitFunctions.forEach(function -> function.accept(isClient));
            postInitFunctions = null;
        }
        blockTags = null;
        itemTags = null;
        InternalBiomeAPI.loadFabricAPIBiomes();
        Configs.BIOMES_CONFIG.saveChanges();
        VersionChecker.startCheck(isClient);
    }

    @Environment(value=EnvType.CLIENT)
    private static void processBlockClient(class_2248 block) {
        if (block instanceof RenderLayerProvider) {
            BCLRenderLayer layer = ((RenderLayerProvider)block).getRenderLayer();
            if (layer == BCLRenderLayer.CUTOUT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
            } else if (layer == BCLRenderLayer.TRANSLUCENT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23583());
            }
        }
        if (block instanceof BaseChestBlock) {
            BaseChestBlockEntityRenderer.registerRenderLayer(block);
        }
    }

    private static void processItemCommon(class_1792 item) {
        if (item instanceof TagProvider) {
            TagProvider provider = (TagProvider)item;
            try {
                provider.addTags(null, itemTags);
            }
            catch (NullPointerException ex) {
                BCLib.LOGGER.error(item + " probably tried to access blockTags.", ex);
            }
            itemTags.forEach(tag -> TagManager.ITEMS.add(tag, item));
            itemTags.clear();
        }
        if (item instanceof BaseShovelItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SHOVELS, class_3489.field_42615);
        } else if (item instanceof BaseSwordItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SWORDS, class_3489.field_42611);
        } else if (item instanceof BasePickaxeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_PICKAXES, class_3489.field_42614);
        } else if (item instanceof BaseAxeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_AXES, class_3489.field_42612);
        } else if (item instanceof BaseHoeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_HOES, class_3489.field_42613);
        } else if (item instanceof BaseShearsItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SHEARS, CommonItemTags.SHEARS);
            class_2315.method_10009((class_1935)item.method_8389(), (class_2357)new class_5168());
        }
    }

    private static void processBlockCommon(class_2248 block) {
        class_2960 location;
        BlockBehaviour c;
        class_1792 item = block.method_8389();
        if (block instanceof PostInitable) {
            ((PostInitable)block).postInit();
        }
        if (block instanceof TagProvider) {
            ((TagProvider)block).addTags(blockTags, itemTags);
            blockTags.forEach(tag -> TagManager.BLOCKS.add((class_6862<class_2248>)tag, (class_2248[])new class_2248[]{block}));
            if (item != null && item != class_1802.field_8162) {
                itemTags.forEach(tag -> TagManager.ITEMS.add(tag, item));
            }
            blockTags.clear();
            itemTags.clear();
        }
        if (block instanceof BaseChestBlock) {
            BaseBlockEntities.CHEST.registerBlock(block);
        } else if (block instanceof BaseBarrelBlock) {
            BaseBlockEntities.BARREL.registerBlock(block);
        } else if (block instanceof BaseFurnaceBlock) {
            BaseBlockEntities.FURNACE.registerBlock(block);
        }
        if (!(block instanceof PreventMineableAdd)) {
            if (block instanceof AddMineableShears) {
                TagManager.BLOCKS.add(block, MineableTags.SHEARS);
            }
            if (!(!(block instanceof AddMineableAxe) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15494, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15499, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15468, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_17619, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15502, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15477, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15491, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_BARREL, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_CHEST, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_COMPOSTER, block) || TagManager.BLOCKS.contains(CommonBlockTags.WORKBENCHES, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15500, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15471, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_15475, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_25147, block) || TagManager.BLOCKS.contains((class_6862<class_2248>)class_3481.field_40105, block) || TagManager.BLOCKS.contains(CommonBlockTags.WORKBENCHES, block) || TagManager.BLOCKS.contains(CommonBlockTags.BOOKSHELVES, block))) {
                TagManager.BLOCKS.add(block, MineableTags.AXE);
            }
            if (block instanceof AddMineablePickaxe) {
                TagManager.BLOCKS.add(block, MineableTags.PICKAXE);
            }
            if (block instanceof AddMineableShovel) {
                TagManager.BLOCKS.add(block, MineableTags.SHOVEL);
            }
            if (block instanceof AddMineableHoe) {
                TagManager.BLOCKS.add(block, MineableTags.HOE);
            }
            if (block instanceof AddMineableSword) {
                TagManager.BLOCKS.add(block, MineableTags.SWORD);
            }
            if (block instanceof AddMineableHammer) {
                TagManager.BLOCKS.add(block, MineableTags.HAMMER);
            }
        }
        if (block instanceof BehaviourCompostable) {
            c = (BehaviourCompostable)block;
            if (item != null && item != class_1802.field_8162) {
                TagManager.ITEMS.add((class_1935)block, CommonItemTags.COMPOSTABLE);
                ComposterAPI.allowCompost(c.compostingChance(), item);
            } else if (BCLib.isDatagen() && Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.warning("Block " + block + " has compostable behaviour but no item!", new Object[0]);
            }
        }
        if (block instanceof BehaviourWaterPlantLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.WATER_PLANT);
        }
        if (block instanceof BehaviourPlant || block instanceof BehaviourShearablePlant) {
            TagManager.BLOCKS.add(block, CommonBlockTags.PLANT);
        }
        if (block instanceof BehaviourSeedLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.SEEDS);
            if (item != null && item != class_1802.field_8162) {
                TagManager.ITEMS.add((class_1935)block, CommonItemTags.SEEDS);
            }
        }
        if (block instanceof BehaviourSaplingLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.SAPLINGS, class_3481.field_15462);
            if (item != null && item != class_1802.field_8162) {
                TagManager.ITEMS.add((class_1935)block, CommonItemTags.SAPLINGS, class_3489.field_15528);
            }
        }
        if (block instanceof BehaviourClimable) {
            c = (BehaviourClimable)block;
            TagManager.BLOCKS.add(block, class_3481.field_22414);
        }
        if (block instanceof BehaviourLeaves) {
            TagManager.BLOCKS.add(block, class_3481.field_15503, CommonBlockTags.LEAVES);
            if (item != null && item != class_1802.field_8162) {
                TagManager.ITEMS.add(item, class_3489.field_15558, CommonItemTags.LEAVES);
            }
        }
        if (block instanceof BehaviourImmobile) {
            TagManager.BLOCKS.add(block, CommonBlockTags.IMMOBILE);
        }
        if (block instanceof BehaviourObsidian) {
            TagManager.BLOCKS.add(block, CommonBlockTags.IS_OBSIDIAN);
        }
        if (block instanceof BehaviourPortalFrame) {
            TagManager.BLOCKS.add(block, CommonBlockTags.NETHER_PORTAL_FRAME);
        }
        if (block instanceof BehaviourOre) {
            TagManager.BLOCKS.add(block, CommonBlockTags.ORES);
        }
        if (block instanceof Fuel) {
            Fuel fl = (Fuel)block;
            FuelRegistry.INSTANCE.add((class_1935)block, (Object)fl.getFuelTime());
        }
        if (BCLib.isDatagen() && !(location = class_7923.field_41175.method_10221((Object)block)).method_12836().equals("minecraft") && !(block instanceof HasMinableBehaviour) && block.method_9564().method_29291()) {
            BCLib.LOGGER.error("Block " + block + "(" + block.getClass() + ") has no mineable behaviour!");
        }
    }
}

