/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.packet.custom;

import com.cerbon.cerbons_api.api.multipart_entities.client.PlayerInteractMultipartEntity;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.network.data.PacketContext;
import com.cerbon.cerbons_api.api.network.data.Side;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MultipartEntityInteractionC2SPacket {
    private final int entityId;
    private final String part;
    private final class_1268 hand;
    private final boolean isSneaking;
    private final PlayerInteractMultipartEntity.InteractionType interactionType;

    public MultipartEntityInteractionC2SPacket(int entityId, String part, class_1268 hand, boolean isSneaking, PlayerInteractMultipartEntity.InteractionType interactionType) {
        this.entityId = entityId;
        this.part = part;
        this.hand = hand;
        this.isSneaking = isSneaking;
        this.interactionType = interactionType;
    }

    public MultipartEntityInteractionC2SPacket(class_2540 buf) {
        this.entityId = buf.readInt();
        this.part = buf.method_10800(Short.MAX_VALUE);
        this.hand = (class_1268)buf.method_10818(class_1268.class);
        this.isSneaking = buf.readBoolean();
        this.interactionType = (PlayerInteractMultipartEntity.InteractionType)buf.method_10818(PlayerInteractMultipartEntity.InteractionType.class);
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.method_10814(this.part);
        buf.method_10817((Enum)this.hand);
        buf.writeBoolean(this.isSneaking);
        buf.method_10817((Enum)this.interactionType);
    }

    public static void handle(PacketContext<MultipartEntityInteractionC2SPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT) || ctx.sender() == null) {
            return;
        }
        class_3222 serverPlayer = ctx.sender();
        MultipartEntityInteractionC2SPacket packet = ctx.message();
        class_3218 serverLevel = serverPlayer.method_51469();
        serverPlayer.method_5660(packet.isSneaking);
        class_1297 entity = serverLevel.method_8469(packet.entityId);
        if (entity == null) {
            return;
        }
        switch (packet.interactionType) {
            case INTERACT: {
                entity.method_5688((class_1657)serverPlayer, packet.hand);
                break;
            }
            case ATTACK: {
                MultipartEntityInteractionC2SPacket.setNextDamagedPart(serverPlayer, entity, packet.part);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private static void setNextDamagedPart(class_3222 serverPlayer, class_1297 entity, String part) {
        if (entity instanceof MultipartAwareEntity) {
            MultipartAwareEntity multipartAwareEntity = (MultipartAwareEntity)entity;
            multipartAwareEntity.setNextDamagedPart(part);
        }
        serverPlayer.method_7324(entity);
    }
}

