/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.multipart_entities.entity;

import com.cerbon.cerbons_api.api.multipart_entities.entity.EntityPart;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MutableBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public final class EntityBounds {
    private CompoundOrientedBox cache;
    private final Map<String, EntityPart> partMap;
    @Nullable
    private final MutableBox overrideBox;

    EntityBounds(Map<String, EntityPart> partMap, @Nullable class_238 overrideBox) {
        this.partMap = partMap;
        this.overrideBox = new MutableBox(overrideBox);
    }

    @Nullable
    public MutableBox getOverrideBox() {
        return this.overrideBox;
    }

    public boolean hasPart(String name) {
        return this.partMap.get(name) != null;
    }

    public EntityPart getPart(String name) {
        return this.partMap.get(name);
    }

    @Nullable
    public String raycast(class_243 start, class_243 end) {
        double t = 1.00001;
        String result = null;
        for (Map.Entry<String, EntityPart> entry : this.partMap.entrySet()) {
            double tmp = entry.getValue().getBox().raycast(start, end);
            if (tmp == -1.0 || !(tmp < t)) continue;
            t = tmp;
            result = entry.getKey();
        }
        return result;
    }

    public CompoundOrientedBox getBox(class_238 bounds) {
        boolean changed = this.cache == null;
        for (EntityPart value : this.partMap.values()) {
            if (!value.isChanged()) continue;
            changed = true;
            value.setChanged(false);
        }
        if (changed) {
            ObjectArrayList parts = new ObjectArrayList(this.partMap.size());
            for (EntityPart value : this.partMap.values()) {
                parts.add(value.getBox());
            }
            this.cache = new CompoundOrientedBox(bounds, (Collection<OrientedBox>)parts, this.overrideBox);
        }
        return this.cache.withBounds(bounds);
    }

    public static EntityBoundsBuilder builder() {
        return new EntityBoundsBuilder();
    }

    public static final class EntityBoundsBuilder {
        private final Map<String, EntityPartInfo> partInfos = new Object2ObjectLinkedOpenHashMap();
        private class_238 overrideBox = null;

        EntityBoundsBuilder addInfo(EntityPartInfo info) {
            if (info.parent != null && !this.partInfos.containsKey(info.parent)) {
                throw new RuntimeException("Unknown part: " + info.parent + ", did you register a child before a parent");
            }
            this.partInfos.put(info.name, info);
            return this;
        }

        public EntityBoundsBuilder overrideCollisionBox(class_238 box) {
            this.overrideBox = box;
            return this;
        }

        public EntityPartInfoBuilder add(String name) {
            if (this.partInfos.containsKey(name)) {
                throw new RuntimeException("Duplicate part: " + name);
            }
            return new EntityPartInfoBuilder(this, name);
        }

        public Factory getFactory() {
            Object2ObjectLinkedOpenHashMap copy = new Object2ObjectLinkedOpenHashMap(this.partInfos);
            return () -> this.lambda$getFactory$0((Map)copy);
        }

        private /* synthetic */ EntityBounds lambda$getFactory$0(Map copy) {
            Object2ObjectOpenHashMap partMap = new Object2ObjectOpenHashMap();
            for (Map.Entry entry : copy.entrySet()) {
                EntityPartInfo info = (EntityPartInfo)entry.getValue();
                EntityPart entityPart = new EntityPart(info.parent != null ? (EntityPart)partMap.get(info.parent) : null, info.bounds, false, info.x, info.y, info.z);
                entityPart.setPivotX(info.px);
                entityPart.setPivotY(info.py);
                entityPart.setPivotZ(info.pz);
                partMap.put((String)entry.getKey(), entityPart);
            }
            return new EntityBounds((Map<String, EntityPart>)partMap, this.overrideBox);
        }
    }

    private record EntityPartInfo(@Nullable String parent, String name, double x, double y, double z, double px, double py, double pz, class_238 bounds) {
    }

    public static final class EntityPartInfoBuilder {
        final EntityBoundsBuilder builder;
        @Nullable
        String parent;
        final String name;
        double x;
        double y;
        double z;
        double px;
        double py;
        double pz;
        class_238 bounds;

        EntityPartInfoBuilder(EntityBoundsBuilder builder, String name) {
            this.builder = builder;
            this.name = name;
        }

        public EntityPartInfoBuilder setOffset(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public EntityPartInfoBuilder setPivot(double x, double y, double z) {
            this.px = x;
            this.py = y;
            this.pz = z;
            return this;
        }

        public EntityPartInfoBuilder setParent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        public EntityPartInfoBuilder setBounds(class_238 bounds) {
            this.bounds = bounds;
            return this;
        }

        public EntityPartInfoBuilder setBounds(double xLength, double yLength, double zLength) {
            this.bounds = new class_238(-xLength / 2.0, -yLength / 2.0, -zLength / 2.0, xLength / 2.0, yLength / 2.0, zLength / 2.0);
            return this;
        }

        public EntityBoundsBuilder build() {
            return this.builder.addInfo(new EntityPartInfo(this.parent, this.name, this.x, this.y, this.z, this.px, this.py, this.pz, this.bounds));
        }
    }

    public static interface Factory {
        public EntityBounds create();
    }
}

