/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs;

import com.almostreliable.lootjs.core.AbstractLootModification;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.LootModificationByBlock;
import com.almostreliable.lootjs.core.LootModificationByEntity;
import com.almostreliable.lootjs.core.LootModificationByTable;
import com.almostreliable.lootjs.core.LootModificationByType;
import com.almostreliable.lootjs.loot.condition.AndCondition;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.LootItemConditionWrapper;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.NotCondition;
import com.almostreliable.lootjs.loot.condition.OrCondition;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.condition.WrappedDamageSourceCondition;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.lootjs.BlockLootModifier;
import com.yanny.ali.lootjs.EntityLootModifier;
import com.yanny.ali.lootjs.TableLootModifier;
import com.yanny.ali.lootjs.TypeLootModifier;
import com.yanny.ali.lootjs.mixin.MixinAbstractLootModification;
import com.yanny.ali.lootjs.mixin.MixinLootModificationsAPI;
import com.yanny.ali.lootjs.modifier.CustomPlayerFunction;
import com.yanny.ali.lootjs.modifier.ModifiedItemFunction;
import com.yanny.ali.lootjs.node.AddLootNode;
import com.yanny.ali.lootjs.node.GroupLootNode;
import com.yanny.ali.lootjs.node.ItemStackNode;
import com.yanny.ali.lootjs.node.ItemTagNode;
import com.yanny.ali.lootjs.node.WeightedAddLootNode;
import com.yanny.ali.lootjs.server.LootJsConditionTooltipUtils;
import com.yanny.ali.lootjs.server.LootJsFunctionTooltipUtils;
import com.yanny.ali.lootjs.server.LootJsGenericTooltipUtils;
import com.yanny.ali.lootjs.widget.AddLootWidget;
import com.yanny.ali.lootjs.widget.GroupedLootWidget;
import com.yanny.ali.lootjs.widget.ItemStackWidget;
import com.yanny.ali.lootjs.widget.ItemTagWidget;
import com.yanny.ali.lootjs.widget.WeightedAddLootWidget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class LootJsPlugin
implements IPlugin {
    public static final String ID = "lootjs";
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getModId() {
        return ID;
    }

    @NotNull
    public static List<ILootModifier<?>> registerModifiers(IServerUtils utils) {
        ArrayList modifiers = new ArrayList();
        List<ILootAction> actions = MixinLootModificationsAPI.getActions();
        for (ILootAction action : actions) {
            if (action instanceof AbstractLootModification) {
                AbstractLootModification lootModification = (AbstractLootModification)action;
                try {
                    if (lootModification instanceof LootModificationByBlock) {
                        LootModificationByBlock byBlock = (LootModificationByBlock)lootModification;
                        modifiers.add(new BlockLootModifier(utils, byBlock));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByEntity) {
                        LootModificationByEntity byEntity = (LootModificationByEntity)lootModification;
                        modifiers.add(new EntityLootModifier(utils, byEntity));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByTable) {
                        LootModificationByTable byTable = (LootModificationByTable)lootModification;
                        modifiers.add(new TableLootModifier(utils, byTable));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByType) {
                        LootModificationByType byType = (LootModificationByType)lootModification;
                        modifiers.add(new TypeLootModifier(utils, byType));
                        continue;
                    }
                    LOGGER.error("Skipping unexpected modification type {}", (Object)lootModification.getClass().getCanonicalName());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.error("Failed to process loot modification {}: {}", (Object)((MixinAbstractLootModification)lootModification).getName(), (Object)e.getMessage());
                }
                continue;
            }
            LOGGER.error("Unexpected action type {}", (Object)action.getClass().getCanonicalName());
        }
        return modifiers;
    }

    @Override
    public void registerClient(IClientRegistry registry) {
        registry.registerDataNode(AddLootNode.ID, AddLootNode::new);
        registry.registerDataNode(WeightedAddLootNode.ID, WeightedAddLootNode::new);
        registry.registerDataNode(ItemStackNode.ID, ItemStackNode::new);
        registry.registerDataNode(ItemTagNode.ID, ItemTagNode::new);
        registry.registerDataNode(GroupLootNode.ID, GroupLootNode::new);
        registry.registerWidget(AddLootNode.ID, AddLootWidget::new);
        registry.registerWidget(WeightedAddLootNode.ID, WeightedAddLootWidget::new);
        registry.registerWidget(ItemStackNode.ID, ItemStackWidget::new);
        registry.registerWidget(ItemTagNode.ID, ItemTagWidget::new);
        registry.registerWidget(GroupLootNode.ID, GroupedLootWidget::new);
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(AndCondition.class, LootJsConditionTooltipUtils::andConditionTooltip);
        registry.registerConditionTooltip(AnyBiomeCheck.class, LootJsConditionTooltipUtils::anyBiomeCheckTooltip);
        registry.registerConditionTooltip(AnyDimension.class, LootJsConditionTooltipUtils::anyDimensionTooltip);
        registry.registerConditionTooltip(AnyStructure.class, LootJsConditionTooltipUtils::anyStructureTooltip);
        registry.registerConditionTooltip(BiomeCheck.class, LootJsConditionTooltipUtils::biomeCheckTooltip);
        registry.registerConditionTooltip(ContainsLootCondition.class, LootJsConditionTooltipUtils::containsLootConditionTooltip);
        registry.registerConditionTooltip(CustomParamPredicate.class, LootJsConditionTooltipUtils::customParamPredicateTooltip);
        registry.registerConditionTooltip(IsLightLevel.class, LootJsConditionTooltipUtils::isLightLevelTooltip);
        registry.registerConditionTooltip(LootItemConditionWrapper.class, LootJsConditionTooltipUtils::lootItemConditionWrapperTooltip);
        registry.registerConditionTooltip(MainHandTableBonus.class, LootJsConditionTooltipUtils::mainHandTableBonusTooltip);
        registry.registerConditionTooltip(MatchEquipmentSlot.class, LootJsConditionTooltipUtils::getMatchEquipmentSlotTooltip);
        registry.registerConditionTooltip(MatchKillerDistance.class, LootJsConditionTooltipUtils::matchKillerDistanceTooltip);
        registry.registerConditionTooltip(MatchPlayer.class, LootJsConditionTooltipUtils::matchPlayerTooltip);
        registry.registerConditionTooltip(NotCondition.class, LootJsConditionTooltipUtils::notConditionTooltip);
        registry.registerConditionTooltip(OrCondition.class, LootJsConditionTooltipUtils::orConditionTooltip);
        registry.registerConditionTooltip(PlayerParamPredicate.class, LootJsConditionTooltipUtils::playerParamPredicateTooltip);
        registry.registerConditionTooltip(WrappedDamageSourceCondition.class, LootJsConditionTooltipUtils::wrapperDamageSourceConditionTooltip);
        registry.registerFunctionTooltip(CustomPlayerFunction.class, LootJsFunctionTooltipUtils::customPlayerTooltip);
        registry.registerFunctionTooltip(ModifiedItemFunction.class, LootJsFunctionTooltipUtils::modifiedItemTooltip);
        registry.registerValueTooltip(AnyStructure.StructureLocator.class, LootJsGenericTooltipUtils::getStructureLocatorTooltip);
        registry.registerLootModifiers(LootJsPlugin::registerModifiers);
    }
}

