/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.fabric;

import com.yanny.ali.fabric.CommonAliMod;
import com.yanny.ali.manager.PluginManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;

public class FabricCommonBusSubscriber {
    private static boolean serverLoaded = false;

    public static void registerEvents() {
        ServerWorldEvents.LOAD.register(FabricCommonBusSubscriber::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(FabricCommonBusSubscriber::onServerStopping);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(FabricCommonBusSubscriber::onReload);
        ServerPlayConnectionEvents.JOIN.register(FabricCommonBusSubscriber::onPlayerLogIn);
    }

    private static void onServerStarting(MinecraftServer server, class_3218 world) {
        if (!serverLoaded) {
            PluginManager.registerServerEvent();
            CommonAliMod.SERVER.readLootTables(server.method_3857(), server.method_30002());
            serverLoaded = true;
        }
    }

    private static void onServerStopping(MinecraftServer server) {
        serverLoaded = false;
        PluginManager.deregisterServerEvent();
    }

    private static void onReload(MinecraftServer server, class_6860 resourceManager, boolean success) {
        if (success) {
            PluginManager.reloadServer();
            CommonAliMod.SERVER.readLootTables(server.method_3857(), server.method_30002());
            for (class_3222 player : server.method_3760().method_14571()) {
                CommonAliMod.SERVER.syncLootTables((class_1657)player);
            }
        }
    }

    private static void onPlayerLogIn(class_3244 event, PacketSender sender, MinecraftServer server) {
        CommonAliMod.SERVER.syncLootTables((class_1657)event.field_14140);
    }
}

