/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.emi.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.emi.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.emi.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.emi.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.emi.compatibility.emi.EmiTradeLoot;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliCommonRegistry;
import com.yanny.ali.manager.PluginManager;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void register(EmiRegistry emiRegistry) {
        GenericUtils.register(emiRegistry, this::registerData);
    }

    private void registerData(EmiRegistry registry, byte[] fullCompressedData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        AliCommonRegistry commonRegistry = PluginManager.COMMON_REGISTRY;
        AliConfig config = commonRegistry.getConfiguration();
        class_638 level = class_310.method_1551().field_1687;
        LOGGER.info("Adding loot information to EMI");
        if (level != null) {
            Map blockCategories = config.blockCategories.stream().collect(EmiCompatibility.getCollector());
            Map entityCategories = config.entityCategories.stream().collect(EmiCompatibility.getCollector());
            Map gameplayCategories = config.gameplayCategories.stream().collect(EmiCompatibility.getCollector());
            Map tradeCategories = config.tradeCategories.stream().collect(EmiCompatibility.getCollector());
            blockCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            tradeCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            GenericUtils.processData(level, clientRegistry, config, fullCompressedData, (node, location, block, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : blockCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(block)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, (class_2960)location, (class_2248)block, (IDataNode)node, (List<class_1799>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : entityCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, (class_2960)location, (class_1299<?>)entity, (IDataNode)node, (List<class_1799>)outputs));
                }
            }, (node, location, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : gameplayCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, (class_2960)location, (IDataNode)node, (List<class_1799>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : tradeCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (class_2960)location, (IDataNode)tradeEntry, (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : tradeCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (class_2960)location, (IDataNode)tradeEntry, (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            });
        } else {
            LOGGER.warn("EMI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static <T> Collector<LootCategory<T>, ?, Map<LootCategory<T>, EmiRecipeCategory>> getCollector() {
        return Collectors.toMap(r -> r, r -> new EmiRecipeCategory(r.getKey(), (EmiRenderable)EmiStack.of((class_1935)r.getIcon())), (e, r) -> e, LinkedHashMap::new);
    }
}

